/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library.model.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.fordiac.ide.library.model.library.LibraryFactory;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Product;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.library.VersionInfo;
import org.eclipse.fordiac.ide.library.model.library.util.LibraryResourceFactoryImpl;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class ManifestHelper {
    private static final String MANIFEST_FILENAME = "MANIFEST.MF";
    private static final String SCOPE_PROJECT = "Project";
    private static final String SCOPE_LIBRARY = "Library";
    private static final String BASE_VERSION = "1.0.0";
    private static final String UTF_8 = "UTF-8";
    private static final String FORDIAC_PROJECT_NATURE_ID = "org.eclipse.fordiac.ide.systemmanagement.FordiacNature";
    private static LibraryFactory factory = LibraryFactory.eINSTANCE;
    private static LibraryResourceFactoryImpl resourceFactory = new LibraryResourceFactoryImpl();

    public static Manifest getOrCreateProjectManifest(IProject project) {
        if (!ManifestHelper.isFordiacProject(project)) {
            return null;
        }
        Manifest manifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (manifest == null) {
            manifest = ManifestHelper.createProjectManifest(project, null);
        }
        return manifest;
    }

    public static Manifest getContainerManifest(IContainer container) {
        IProject project;
        if (container == null || container instanceof IProject && !ManifestHelper.isFordiacProject(project = (IProject)container)) {
            return null;
        }
        IFile manifest = container.getFile((IPath)new Path(MANIFEST_FILENAME));
        return ManifestHelper.getManifest(manifest);
    }

    public static Manifest getFolderManifest(File container) {
        if (container == null || !container.isDirectory()) {
            return null;
        }
        File[] files = container.listFiles((dir, name) -> MANIFEST_FILENAME.equals(name));
        if (files.length == 0) {
            return null;
        }
        return ManifestHelper.getManifest(files[0]);
    }

    public static Manifest getFolderManifest(java.nio.file.Path path) {
        if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(path, MANIFEST_FILENAME);){
                Iterator<java.nio.file.Path> it = stream.iterator();
                if (it.hasNext()) {
                    return ManifestHelper.getManifest(it.next());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Manifest getManifest(IFile manifest) {
        if (manifest == null || !manifest.exists()) {
            return null;
        }
        return ManifestHelper.getManifest(URI.createURI((String)manifest.getLocationURI().toString()));
    }

    public static Manifest getManifest(File manifest) {
        if (manifest == null || !manifest.exists()) {
            return null;
        }
        return ManifestHelper.getManifest(URI.createURI((String)manifest.toURI().toString()));
    }

    public static Manifest getManifest(java.nio.file.Path manifest) {
        if (manifest == null || Files.notExists(manifest, new LinkOption[0])) {
            return null;
        }
        return ManifestHelper.getManifest(URI.createURI((String)manifest.toUri().toString()));
    }

    public static Manifest createProjectManifest(IProject project, Collection<Required> dependencies) {
        Manifest manifest = ManifestHelper.createManifest(SCOPE_PROJECT);
        IFile manifestFile = project.getFile(MANIFEST_FILENAME);
        XMLResource resource = ManifestHelper.createResource(URI.createURI((String)manifestFile.getLocationURI().toString()));
        if (dependencies != null) {
            for (Required req : dependencies) {
                ManifestHelper.addDependency(manifest, req);
            }
        }
        resource.getContents().add((Object)manifest);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            FordiacLogHelper.logWarning((String)"Could not create project manifest", (Exception)e);
        }
        return manifest;
    }

    public static Manifest createManifest(String scope) {
        Manifest manifest = factory.createManifest();
        manifest.setScope(scope);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        VersionInfo versionInfo = factory.createVersionInfo();
        versionInfo.setAuthor("");
        versionInfo.setVersion(BASE_VERSION);
        versionInfo.setDate(formatter.format(LocalDate.now()));
        Product product = factory.createProduct();
        product.setVersionInfo(versionInfo);
        manifest.setProduct(product);
        return manifest;
    }

    public static boolean isProject(Manifest manifest) {
        return SCOPE_PROJECT.equals(manifest.getScope());
    }

    public static boolean isLibrary(Manifest manifest) {
        return SCOPE_LIBRARY.equals(manifest.getScope());
    }

    public static boolean addDependency(Manifest manifest, Required dependency) {
        if (manifest.getDependencies() == null) {
            manifest.setDependencies(factory.createDependencies());
        }
        EList<Required> reqList = manifest.getDependencies().getRequired();
        int index = 0;
        while (index < reqList.size()) {
            int comp = ((Required)reqList.get(index)).getSymbolicName().compareTo(dependency.getSymbolicName());
            if (comp == 0) {
                reqList.set(index, (Object)dependency);
                return true;
            }
            if (comp > 0) {
                reqList.add(index, (Object)dependency);
                return true;
            }
            ++index;
        }
        reqList.add(index, (Object)dependency);
        return true;
    }

    public static boolean removeDependency(Manifest manifest, Required dependency) {
        if (manifest.getDependencies() == null) {
            return false;
        }
        return manifest.getDependencies().getRequired().remove((Object)dependency);
    }

    public static void updateDependency(Manifest manifest, Required dependency) {
        if (manifest.getDependencies() == null) {
            manifest.setDependencies(factory.createDependencies());
        }
        ManifestHelper.sortManifestDependencies(manifest);
        EList<Required> reqList = manifest.getDependencies().getRequired();
        int index = 0;
        while (index < reqList.size()) {
            int comp = ((Required)reqList.get(index)).getSymbolicName().compareTo(dependency.getSymbolicName());
            if (comp == 0) {
                if (!VersionComparator.contains(((Required)reqList.get(index)).getVersion(), dependency.getVersion())) {
                    reqList.set(index, (Object)dependency);
                }
                return;
            }
            if (comp > 0) {
                reqList.add(index, (Object)dependency);
                return;
            }
            ++index;
        }
        reqList.add(index, (Object)dependency);
    }

    public static XMLResource createResource(URI uri) {
        XMLResource resource = (XMLResource)resourceFactory.createResource(uri);
        resource.getDefaultSaveOptions().put("ENCODING", UTF_8);
        resource.getDefaultLoadOptions().put("ENCODING", UTF_8);
        return resource;
    }

    public static Manifest getManifest(URI uri) {
        XMLResource resource = ManifestHelper.createResource(uri);
        try {
            resource.load(null);
        }
        catch (IOException e) {
            FordiacLogHelper.logWarning((String)"Could not load manifest", (Exception)e);
            return null;
        }
        return (Manifest)resource.getContents().get(0);
    }

    public static boolean saveManifest(Manifest manifest) {
        try {
            manifest.eResource().save(null);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean sortManifestDependencies(Manifest manifest) {
        if (manifest.getDependencies() == null) {
            return false;
        }
        BasicEList dependencies = new BasicEList(manifest.getDependencies().getRequired());
        ECollections.sort(manifest.getDependencies().getRequired(), (o1, o2) -> o1.getSymbolicName().compareTo(o2.getSymbolicName()));
        return !dependencies.equals(manifest.getDependencies().getRequired());
    }

    public static Required createRequired(String symbolicName, String version) {
        Required required = factory.createRequired();
        required.setSymbolicName(symbolicName);
        required.setVersion(version);
        return required;
    }

    private static boolean isFordiacProject(IProject project) {
        try {
            return project.getNature(FORDIAC_PROJECT_NATURE_ID) != null;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ManifestHelper() {
    }
}

