/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.nat.AbstractAnnotatedConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class AttributeDeclarationConfigLabelAccumulator
extends AbstractAnnotatedConfigLabelAccumulator<Attribute> {
    private final List<AttributeDeclarationTableColumn> columns;

    public AttributeDeclarationConfigLabelAccumulator(IRowDataProvider<Attribute> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier, List<AttributeDeclarationTableColumn> columns) {
        super(dataProvider, annotationModelSupplier);
        this.columns = columns;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        AttributeDeclarationTableColumn column = this.columns.get(columnPosition);
        if (column == AttributeDeclarationTableColumn.COMMENT) {
            configLabels.addLabelOnTop("LEFT_ALIGNMENT");
            if (!CommentHelper.hasComment((INamedElement)((INamedElement)this.getDataProvider().getRowObject(rowPosition)))) {
                configLabels.addLabelOnTop("DEFAULT_CELL");
            }
        }
        if (column == AttributeDeclarationTableColumn.FILE_PATH || column == AttributeDeclarationTableColumn.LOCATION || column == AttributeDeclarationTableColumn.TYPE) {
            configLabels.addLabelOnTop("LEFT_TRUNCATING");
        }
        if (column == AttributeDeclarationTableColumn.VALUE) {
            configLabels.addLabel("INITIAL_VALUE_CELL");
            if (!InitialValueHelper.hasInitalValue((Object)this.getDataProvider().getRowObject(rowPosition))) {
                configLabels.addLabelOnTop("DEFAULT_CELL");
            }
            this.accumulateAttributeConfigLabels(configLabels, this.getDataProvider().getRowObject(rowPosition), FordiacAnnotationUtil::showOnTargetValue);
        }
    }
}

