/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.gef.properties.AbstractDoubleColumnSection;
import org.eclipse.fordiac.ide.gef.widgets.PackageInfoWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class TypeInfoSection
extends AbstractDoubleColumnSection {
    private PackageInfoWidget typeInfo;
    private Text fbTypeNameText;
    private Text commentText;
    private final Adapter typeInfoAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            TypeInfoSection.this.notifiyRefresh();
        }
    };

    protected LibraryElement getType() {
        return (LibraryElement)this.type;
    }

    @Override
    protected void setInputInit() {
        this.typeInfo.initialize(this.getType(), this::executeCommand);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeAndCommentSection(this.getLeftComposite());
        this.typeInfo = new PackageInfoWidget((FormToolkit)this.getWidgetFactory(), this::getAnnotationModel);
        this.typeInfo.createControls(this.getLeftComposite(), this.getRightComposite());
    }

    private void createTypeAndCommentSection(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.TypeName + ":");
        this.fbTypeNameText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, FordiacMessages.Comment + ":");
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(e -> this.executeCommand((Command)new ChangeCommentCommand((INamedElement)this.getType(), this.commentText.getText())));
    }

    @Override
    public void setInputCode() {
        this.commentText.setEnabled(false);
        this.typeInfo.setEnabled(false);
    }

    @Override
    protected void performRefresh() {
        this.fbTypeNameText.setText(this.getType().getName() != null ? this.getType().getName() : "");
        this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
        this.commentText.setEditable(!(this.getType() instanceof FunctionFBType));
        this.typeInfo.refresh();
    }

    @Override
    protected void performRefreshAnnotations() {
        this.typeInfo.refreshAnnotations();
    }

    @Override
    protected void addContentAdapter() {
        super.addContentAdapter();
        if (this.getType() != null && this.getType().getIdentification() != null) {
            this.getType().getIdentification().eAdapters().add((Object)this.typeInfoAdapter);
        }
    }

    @Override
    protected void removeContentAdapter() {
        super.removeContentAdapter();
        if (this.getType() != null && this.getType().getIdentification() != null) {
            this.getType().getIdentification().eAdapters().remove((Object)this.typeInfoAdapter);
        }
    }
}

