/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.gef.editparts.InitialValueCellEditor;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class InitialValueStructuredCellEditor
extends InitialValueCellEditor {
    private Control textControl;
    private boolean variableDialogOpen;
    private boolean hasFocus = true;

    public InitialValueStructuredCellEditor(Composite parent, VarDeclaration varDeclaration) {
        super(parent, varDeclaration);
    }

    public InitialValueStructuredCellEditor(Composite parent, VarDeclaration varDeclaration, int style) {
        super(parent, varDeclaration, style);
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.textControl = super.createControl(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.textControl);
        this.textControl.addFocusListener(FocusListener.focusGainedAdapter(event -> {
            boolean bl = this.hasFocus = true;
        }));
        Button dialogButton = new Button(composite, 0x800000);
        dialogButton.setText("\u2026");
        dialogButton.addFocusListener(FocusListener.focusGainedAdapter(event -> {
            boolean bl = this.hasFocus = true;
        }));
        dialogButton.addFocusListener(FocusListener.focusLostAdapter(event -> this.focusLost()));
        dialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.openDialog()));
        GridDataFactory.swtDefaults().applyTo((Control)dialogButton);
        return composite;
    }

    protected void openDialog() {
        try {
            this.variableDialogOpen = true;
            String initialValue = FordiacMessages.ValueTooLarge.equals(this.text.getText()) ? null : this.text.getText();
            VariableDialog.open(this.getControl().getShell(), (ITypedElement)this.getVarDeclaration(), initialValue).ifPresent(arg_0 -> ((StyledText)this.text).setText(arg_0));
        }
        finally {
            this.textControl.forceFocus();
            this.variableDialogOpen = false;
        }
    }

    protected void focusLost() {
        this.hasFocus = false;
        Display.getCurrent().timerExec(100, () -> {
            if (!this.variableDialogOpen && !this.hasFocus) {
                super.focusLost();
            }
        });
    }
}

