/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.basic;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.base.BaseFBImplTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class BasicFBImplTemplate
extends BaseFBImplTemplate<BasicFBType> {
    private final Map<ECTransition, ILanguageSupport> transitionLanguageSupport;

    public BasicFBImplTemplate(BasicFBType type, String name, Path prefix, Map<?, ?> options) {
        super(type, name, prefix, "CBasicFB", options);
        Functions.Function1 _function = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.transitionLanguageSupport = IterableExtensions.toInvertedMap((Iterable)type.getECC().getECTransition(), (Functions.Function1)_function);
    }

    protected CharSequence generateStates() {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ((BasicFBType)this.getType()).getECC().getECState();
        for (ECState state : _eCState) {
            CharSequence _generateState = this.generateState(state);
            _builder.append((Object)_generateState);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateState(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::enterState");
        String _name = state.getName();
        _builder.append(_name);
        _builder.append("(CEventChainExecutionThread *const");
        boolean _hasOutputEvent = BasicFBImplTemplate.hasOutputEvent(state);
        if (_hasOutputEvent) {
            _builder.append(" paECET");
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("mECCState = ");
        CharSequence _generateStateName = this.generateStateName(state);
        _builder.append((Object)_generateStateName, "  ");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        EList _eCAction = state.getECAction();
        for (ECAction action : _eCAction) {
            Event _output;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            Algorithm _algorithm = action.getAlgorithm();
            boolean bl = _tripleNotEquals = _algorithm != null;
            if (_tripleNotEquals) {
                _builder.append("  ");
                _builder.append("alg_");
                String _name_1 = action.getAlgorithm().getName();
                _builder.append(_name_1, "  ");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _tripleNotEquals_1 = (_output = action.getOutput()) != null;
            if (!_tripleNotEquals_1) continue;
            _builder.append("  ");
            CharSequence _generateSendEvent = this.generateSendEvent(action.getOutput());
            _builder.append((Object)_generateSendEvent, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private static boolean hasOutputEvent(ECState state) {
        Functions.Function1 _function = it -> {
            Event _output = it.getOutput();
            return _output != null;
        };
        return IterableExtensions.exists((Iterable)state.getECAction(), (Functions.Function1)_function);
    }

    @Override
    public CharSequence generateExecuteEvent() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::executeEvent(TEventID paEIID, CEventChainExecutionThread *const paECET) {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append("do {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("switch(mECCState) {");
        _builder.newLine();
        EList _eCState = ((BasicFBType)this.getType()).getECC().getECState();
        for (ECState state : _eCState) {
            boolean _not_1;
            boolean _not;
            _builder.append("      ");
            _builder.append("case ");
            CharSequence _generateStateName = this.generateStateName(state);
            _builder.append((Object)_generateStateName, "      ");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EList _outTransitions = state.getOutTransitions();
            boolean _hasElements = false;
            for (ECTransition transition : _outTransitions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\nelse", "        ");
                }
                _builder.append("      ");
                _builder.append("  ");
                _builder.append("if(");
                CharSequence _generateTransitionCondition = this.generateTransitionCondition(transition);
                _builder.append((Object)_generateTransitionCondition, "        ");
                _builder.append(") enterState");
                String _name = transition.getDestination().getName();
                _builder.append(_name, "        ");
                _builder.append("(paECET);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("      ");
            _builder.append("  ");
            boolean _isEmpty = state.getOutTransitions().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                _builder.append("else ");
            }
            _builder.append("return; //no transition cleared");
            _builder.newLineIfNotEmpty();
            _builder.append("      ");
            _builder.append("  ");
            boolean _isEmpty_1 = state.getOutTransitions().isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                _builder.append("break;");
            }
            _builder.newLineIfNotEmpty();
        }
        _builder.append("      ");
        _builder.append("default:");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("DEVLOG_ERROR(\"The state is not in the valid range! The state value is: %d. The max value can be: ");
        int _size = ((BasicFBType)this.getType()).getECC().getECState().size();
        _builder.append((Object)_size, "        ");
        _builder.append(".\", mECCState.operator TForteUInt16 ());");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("mECCState = 0; // 0 is always the initial state");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("paEIID = cgInvalidEventID; // we have to clear the event after the first check in order to ensure correct behavior");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("} while(true);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateStates = this.generateStates();
        _builder.append((Object)_generateStates);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateTransitionCondition(ECTransition transition) {
        try {
            String _switchResult = null;
            ECTransition it = transition;
            boolean _matched = false;
            if (it.getConditionEvent() != null && !StringExtensions.isNullOrEmpty((String)it.getConditionExpression())) {
                _matched = true;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("(");
                CharSequence _generateTransitionEvent = this.generateTransitionEvent(transition.getConditionEvent());
                _builder.append((Object)_generateTransitionEvent);
                _builder.append(" == paEIID) && (");
                ILanguageSupport _get = this.transitionLanguageSupport.get(transition);
                CharSequence _generate = null;
                if (_get != null) {
                    _generate = _get.generate(CollectionLiterals.emptyMap());
                }
                _builder.append(_generate);
                _builder.append(")");
                _switchResult = _builder;
            }
            if (!_matched) {
                boolean _tripleNotEquals;
                Event _conditionEvent = it.getConditionEvent();
                boolean bl = _tripleNotEquals = _conditionEvent != null;
                if (_tripleNotEquals) {
                    _matched = true;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    CharSequence _generateTransitionEvent_1 = this.generateTransitionEvent(transition.getConditionEvent());
                    _builder_1.append((Object)_generateTransitionEvent_1);
                    _builder_1.append(" == paEIID");
                    _switchResult = _builder_1;
                }
            }
            if (!_matched) {
                boolean _not;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getConditionExpression());
                boolean bl = _not = !_isNullOrEmpty;
                if (_not) {
                    _matched = true;
                    String _xifexpression = null;
                    String _conditionExpression = it.getConditionExpression();
                    boolean _equals = Objects.equals(_conditionExpression, "1");
                    if (_equals) {
                        _xifexpression = "1";
                    } else {
                        ILanguageSupport _get_1 = this.transitionLanguageSupport.get(transition);
                        CharSequence _generate_1 = null;
                        if (_get_1 != null) {
                            _generate_1 = _get_1.generate(CollectionLiterals.emptyMap());
                        }
                        _xifexpression = _generate_1;
                    }
                    _switchResult = _xifexpression;
                }
            }
            if (!_matched) {
                _switchResult = "1";
            }
            return _switchResult;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected CharSequence generateTransitionEvent(Event event) {
        CharSequence _xblockexpression = null;
        BlockFBNetworkElement fbNetworkElement = event.getBlockFBNetworkElement();
        if (fbNetworkElement instanceof AdapterFB) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generateName = ForteNgExportUtil.generateName((AdapterFB)fbNetworkElement);
            _builder.append((Object)_generateName);
            _builder.append("->");
            CharSequence _generateName_1 = ForteNgExportUtil.generateName((IInterfaceElement)event);
            _builder.append((Object)_generateName_1);
            _builder.append("()");
            return _builder.toString();
        }
        _xblockexpression = this.generateEventID(event);
        return _xblockexpression;
    }

    protected CharSequence generateStateName(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("scmState");
        String _name = state.getName();
        _builder.append(_name);
        return _builder;
    }

    @Override
    public List<String> getErrors() {
        List<String> _errors = super.getErrors();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.transitionLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_errors, (Iterable)_set));
    }

    @Override
    public List<String> getWarnings() {
        List<String> _warnings = super.getWarnings();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.transitionLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_warnings, (Iterable)_set));
    }

    @Override
    public List<String> getInfos() {
        List<String> _infos = super.getInfos();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.transitionLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_infos, (Iterable)_set));
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _dependencies = super.getDependencies(options);
        Functions.Function1 _function = it -> it.getDependencies(options);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.transitionLanguageSupport.values()), (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_dependencies, (Iterable)_flatMap));
    }
}

