/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.commands.NewSubAppCommand;
import org.eclipse.fordiac.ide.application.figures.InstanceNameFigure;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.commands.change.ToggleSubAppRepresentationCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteGroupCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.gef.commands.Command;

public class ConvertGroupToSubappCommand
extends Command
implements ScopedCommand {
    private final Group sourceGroup;
    private final FBNetwork fbNetwork;
    private final NewSubAppCommand createSubappCmd;
    private ChangeNameCommand copyNameCmd;
    private ChangeCommentCommand copyCommentCmd;
    private ToggleSubAppRepresentationCommand expandCommand;
    private DeleteGroupCommand deleteGroupCmd;

    public ConvertGroupToSubappCommand(Group source) {
        this.sourceGroup = Objects.requireNonNull(source);
        this.fbNetwork = this.sourceGroup.getFbNetwork();
        this.createSubappCmd = new NewSubAppCommand(this.fbNetwork, (List<?>)this.sourceGroup.getGroupElements(), this.sourceGroup.getPosition());
    }

    public void execute() {
        this.createSubappCmd.execute();
        UntypedSubApp destinationSubapp = this.createSubappCmd.getElement();
        destinationSubapp.setWidth(this.sourceGroup.getWidth());
        destinationSubapp.setHeight((double)((int)(this.sourceGroup.getHeight() + CoordinateConverter.INSTANCE.getLineHeight() + (double)InstanceNameFigure.INSTANCE_LABEL_MARGIN)));
        this.copyNameCmd = ChangeNameCommand.forName((INamedElement)destinationSubapp, (String)this.sourceGroup.getName());
        this.copyNameCmd.execute();
        this.copyCommentCmd = new ChangeCommentCommand((INamedElement)destinationSubapp, this.sourceGroup.getComment());
        this.copyCommentCmd.execute();
        this.expandCommand = new ToggleSubAppRepresentationCommand((SubApp)destinationSubapp);
        this.expandCommand.execute();
        this.deleteGroupCmd = new DeleteGroupCommand(this.sourceGroup);
        this.deleteGroupCmd.execute();
    }

    public boolean canExecute() {
        return this.createSubappCmd.canExecute();
    }

    public void undo() {
        this.deleteGroupCmd.undo();
        this.copyNameCmd.undo();
        this.copyCommentCmd.undo();
        this.expandCommand.undo();
        this.createSubappCmd.undo();
    }

    public void redo() {
        this.createSubappCmd.redo();
        this.copyNameCmd.redo();
        this.copyCommentCmd.redo();
        this.expandCommand.redo();
        this.deleteGroupCmd.redo();
    }

    public SubApp getCreatedElement() {
        return this.createSubappCmd.getElement();
    }

    public Set<EObject> getAffectedObjects() {
        if (this.fbNetwork != null) {
            return Set.of(this.fbNetwork);
        }
        return Set.of();
    }
}

