/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.utilities;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SubAppHierarchyDialog {
    private final FBNetwork root;
    private TreeNode rootNode;
    private final List<EObject> initialSelectionElements;
    private final List<TreeNode> initalSelection = new ArrayList<TreeNode>();
    private final ElementTreeSelectionDialog dialog;

    public SubAppHierarchyDialog(IProject project, List<EObject> initialSelectionElements) {
        this.root = null;
        this.initialSelectionElements = initialSelectionElements;
        List<TreeNode> nodeList = this.buildNodeList(TypeLibraryManager.INSTANCE.getTypeLibrary(project));
        this.dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new TreeNodeLabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider()){

            protected TreeViewer createTreeViewer(Composite parent) {
                Composite buttonsComposite = new Composite(parent, 0);
                buttonsComposite.setLayout((Layout)new GridLayout(2, false));
                TreeViewer viewer = super.createTreeViewer(parent);
                Button expandAll = (Button)WidgetFactory.button((int)0).image(FordiacImage.ICON_EXPAND_ALL.getImage()).create((Widget)buttonsComposite);
                expandAll.addListener(13, event -> viewer.expandAll());
                Button collapseAll = (Button)WidgetFactory.button((int)0).image(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL")).create((Widget)buttonsComposite);
                collapseAll.addListener(13, event -> viewer.collapseAll());
                return viewer;
            }
        };
        this.dialog.setInitialSelections((Object[])this.initalSelection.toArray(Object[]::new));
        this.dialog.setInput((Object)nodeList.toArray(new TreeNode[0]));
        this.dialog.setTitle(Messages.SubAppHierarchyDialogTitle);
    }

    public SubAppHierarchyDialog(FBNetworkElement root, List<FBNetworkElement> filteredElements) {
        this.root = (FBNetwork)root.eContainer();
        this.initialSelectionElements = Collections.emptyList();
        List<TreeNode> nodeList = this.buildNodeList(filteredElements);
        this.dialog = this.createDialog();
        this.dialog.setInput((Object)nodeList.toArray(new TreeNode[0]));
        this.dialog.setTitle(Messages.MoveElementDialogTitle);
        this.dialog.setAllowMultiple(false);
        this.dialog.setInitialSelection((Object)this.rootNode);
    }

    public FBNetwork mapResultToFBNetwork(Object[] result) {
        TreeNode node;
        Object firstResult;
        Object object = firstResult = result != null ? this.dialog.getResult()[0] : null;
        if (firstResult instanceof TreeNode && (node = (TreeNode)firstResult) != this.rootNode) {
            Object object2 = node.getValue();
            Objects.requireNonNull(object2);
            Object object3 = object2;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SubApp.class, Application.class, CompositeFBType.class}, (Object)object3, 0)) {
                case 0 -> {
                    SubApp subapp = (SubApp)object3;
                    yield subapp.getSubAppNetwork();
                }
                case 1 -> {
                    Application app = (Application)object3;
                    yield app.getFBNetwork();
                }
                case 2 -> {
                    CompositeFBType cfb = (CompositeFBType)object3;
                    yield cfb.getFBNetwork();
                }
                default -> null;
            };
        }
        return null;
    }

    public static List<URI> mapResultToURIs(Object[] result) {
        if (result != null) {
            return Arrays.stream(result).filter(TreeNode.class::isInstance).map(node -> ((TreeNode)node).getValue()).map(value -> {
                if (value instanceof EObject) {
                    EObject eobj = (EObject)value;
                    return EcoreUtil.getURI((EObject)eobj);
                }
                return null;
            }).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    public Object[] open() {
        this.dialog.open();
        return this.dialog.getResult();
    }

    private ElementTreeSelectionDialog createDialog() {
        return new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TreeNodeLabelProvider()), (ITreeContentProvider)new TreeNodeContentProvider()){

            protected TreeViewer createTreeViewer(Composite parent) {
                TreeViewer viewer = super.createTreeViewer(parent);
                viewer.expandAll();
                return viewer;
            }
        };
    }

    private List<TreeNode> buildNodeList(TypeLibrary typeLib) {
        Stream<SubAppType> stream = Stream.concat(typeLib.getSystems().stream().map(SystemEntry::getSystem), typeLib.getSubAppTypes().stream().map(SubAppTypeEntry::getType));
        return this.buildNodeList(stream, Collections.emptyList());
    }

    private List<TreeNode> buildNodeList(List<FBNetworkElement> filterList) {
        LibraryElement le = ModelHelper.getLibraryElementFromContextChecked((EObject)this.root);
        if (le instanceof AutomationSystem) {
            AutomationSystem automationSystem = (AutomationSystem)le;
            return this.buildNodeList(automationSystem.getApplication().stream(), filterList);
        }
        return this.buildNodeList(Stream.of(le), filterList);
    }

    private List<TreeNode> buildNodeList(Stream<? extends EObject> roots, List<FBNetworkElement> filterList) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        roots.forEach(r -> {
            if (r instanceof Application) {
                Application application = (Application)r;
                TreeNode node = new TreeNode((Object)application);
                nodeList.add(node);
                if (this.initialSelectionElements.contains(application)) {
                    this.initalSelection.add(node);
                }
                if (this.root != null && application.getFBNetwork() == this.root) {
                    this.rootNode = node;
                }
                this.addFBNetwork(node, application.getFBNetwork(), filterList);
            } else if (r instanceof SubAppType) {
                SubAppType subappType = (SubAppType)r;
                TreeNode node = new TreeNode((Object)subappType);
                nodeList.add(node);
                if (this.initialSelectionElements.contains(subappType)) {
                    this.initalSelection.add(node);
                }
                if (this.root != null && subappType.getFBNetwork() == this.root) {
                    this.rootNode = node;
                }
                this.addFBNetwork(node, subappType.getFBNetwork(), filterList);
            } else if (r instanceof AutomationSystem) {
                AutomationSystem automationSystem = (AutomationSystem)r;
                ArrayList childrenList = new ArrayList();
                TreeNode systemNode = new TreeNode((Object)automationSystem);
                nodeList.add(systemNode);
                if (this.initialSelectionElements.contains(automationSystem)) {
                    this.initalSelection.add(systemNode);
                }
                automationSystem.getApplication().forEach(app -> {
                    TreeNode node = new TreeNode(app);
                    node.setParent(systemNode);
                    childrenList.add(node);
                    if (this.initialSelectionElements.contains(app)) {
                        this.initalSelection.add(node);
                    }
                    this.addFBNetwork(node, app.getFBNetwork(), filterList);
                });
                systemNode.setChildren(childrenList.toArray(new TreeNode[0]));
            }
        });
        return nodeList;
    }

    private void addFBNetwork(TreeNode parent, FBNetwork network, List<FBNetworkElement> filterList) {
        ArrayList nodeList = new ArrayList();
        network.getNetworkElements().forEach(fbnE -> {
            if (fbnE instanceof UntypedSubApp) {
                UntypedSubApp subapp = (UntypedSubApp)fbnE;
                if (!filterList.contains(fbnE)) {
                    TreeNode node = new TreeNode((Object)subapp);
                    if (this.root != null && subapp.getSubAppNetwork() == this.root) {
                        this.rootNode = node;
                    }
                    node.setParent(parent);
                    nodeList.add(node);
                    if (this.initialSelectionElements.contains(subapp)) {
                        this.initalSelection.add(node);
                    }
                    this.addFBNetwork(node, subapp.getSubAppNetwork(), filterList);
                }
            }
        });
        parent.setChildren(nodeList.toArray(new TreeNode[0]));
    }

    private class TreeNodeLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private TreeNodeLabelProvider() {
        }

        public String getText(Object element) {
            TreeNode treeNode;
            Object object;
            if (element instanceof TreeNode && (object = (treeNode = (TreeNode)element).getValue()) instanceof INamedElement) {
                INamedElement e = (INamedElement)object;
                return e.getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof TreeNode) {
                TreeNode node = (TreeNode)element;
                if (node.getValue() instanceof UntypedSubApp) {
                    return FordiacImage.ICON_SUB_APP.getImage();
                }
                if (node.getValue() instanceof TypedSubApp) {
                    return FordiacImage.ICON_SUB_APP.getImage();
                }
                if (node.getValue() instanceof SubAppType) {
                    return FordiacImage.ICON_SUB_APP_TYPE.getImage();
                }
                if (node.getValue() instanceof Application) {
                    return FordiacImage.ICON_APPLICATION.getImage();
                }
                if (node.getValue() instanceof AutomationSystem) {
                    return FordiacImage.ICON_SYSTEM.getImage();
                }
            }
            return super.getImage(element);
        }

        public StyledString getStyledText(Object element) {
            TreeNode treeNode;
            if (element instanceof TreeNode && (treeNode = (TreeNode)element) == SubAppHierarchyDialog.this.rootNode) {
                StyledString styledString = new StyledString(this.getText(element));
                styledString.append(" - current Network", StyledString.QUALIFIER_STYLER);
                return styledString;
            }
            return new StyledString(this.getText(element));
        }
    }
}

