/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateInternalFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateUntypedSubAppInterfaceCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class UpdateFBInstanceModelEdit
extends ModelEdit<BlockFBNetworkElement> {
    protected final TypeEntry typeEntry;

    public UpdateFBInstanceModelEdit(BlockFBNetworkElement instance, TypeEntry typeEntry) {
        super(MessageFormat.format(Messages.UpdateFBInstances, FBNetworkHelper.getFullHierarchicalName((FBNetworkElement)instance)), EcoreUtil.getURI((EObject)instance), BlockFBNetworkElement.class);
        this.typeEntry = typeEntry;
    }

    @Override
    public void initializeValidationData(BlockFBNetworkElement element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(BlockFBNetworkElement element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (element.eContainer() == null) {
            status.addError(element.getQualifiedName() + " eContainer is null");
        }
        return status;
    }

    @Override
    protected Command createCommand(BlockFBNetworkElement element) {
        TypeEntry typeEntry;
        SubApp subApp;
        if (element instanceof SubApp && !(subApp = (SubApp)element).isTyped() && (typeEntry = this.typeEntry) instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
            return new UpdateUntypedSubAppInterfaceCommand((FBNetworkElement)element, dtEntry);
        }
        if (element instanceof StructManipulator) {
            StructManipulator muxer = (StructManipulator)element;
            LibraryElement libraryElement = this.typeEntry.getType();
            if (libraryElement instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)libraryElement;
                return new ChangeStructCommand(muxer, (DataType)structuredType);
            }
        }
        if (element instanceof ConfigurableFB) {
            ConfigurableFB confFb = (ConfigurableFB)element;
            LibraryElement libraryElement = this.typeEntry.getType();
            if (libraryElement instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)libraryElement;
                return new ConfigureFBCommand(confFb, (DataType)structuredType);
            }
        }
        if (element.eContainer() instanceof BaseFBType && element instanceof FB) {
            FB fb = (FB)element;
            return new UpdateInternalFBCommand(fb, this.typeEntry);
        }
        return new UpdateFBTypeCommand(element, this.typeEntry);
    }
}

