/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.preferences;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.tracer.TracingConstant;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.DataHolder;
import org.eclipse.emf.compare.rcp.ui.internal.preferences.impl.InteractiveUIContent;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PostProcessorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private DataHolder<IPostProcessor.Descriptor> dataHolder = new DataHolder();
    private InteractiveUIContent interactiveUI;

    public PostProcessorPreferencePage() {
    }

    public PostProcessorPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public PostProcessorPreferencePage(String title) {
        super(title);
    }

    public void init(IWorkbench workbench) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)store);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().equalWidth(true).applyTo(container);
        Label introductionText = new Label(container, 64);
        introductionText.setText(EMFCompareRCPUIMessages.getString("PostProcessorPreferencePage.preferencePage.description"));
        IItemRegistry postProcessorRegistryDescriptor = EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry();
        Set activesPostProcessor = ItemUtil.getActiveItems((IItemRegistry)postProcessorRegistryDescriptor, (String)"org.eclipse.emf.compare.rcp", (String)"org.eclipse.emf.compare.preference.postprocessor.disabled");
        InteractiveUIContent.InteractiveUIBuilder postProcessorUIBuilder = new InteractiveUIContent.InteractiveUIBuilder(container, postProcessorRegistryDescriptor);
        LinkedHashSet descriptors = Sets.newLinkedHashSet((Iterable)postProcessorRegistryDescriptor.getItemDescriptors());
        postProcessorUIBuilder.setConfigurationNodeKey("org.eclipse.emf.compare.preference.postprocessor.disabled").setDefaultCheck(descriptors).setDefaultSelection(postProcessorRegistryDescriptor.getHighestRankingDescriptor()).setHoldingData(this.dataHolder).setDefaultCheck(activesPostProcessor);
        this.interactiveUI = postProcessorUIBuilder.build();
        return container;
    }

    public boolean performOk() {
        LinkedHashSet postProcessorDescriptors = Sets.newLinkedHashSet((Iterable)EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry().getItemDescriptors());
        Sets.SetView postProcessorToDisable = Sets.difference((Set)postProcessorDescriptors, this.dataHolder.getData());
        this.setEnginePreferences("org.eclipse.emf.compare.preference.postprocessor.disabled", (Set<IItemDescriptor<IPostProcessor.Descriptor>>)postProcessorToDisable);
        if (TracingConstant.CONFIGURATION_TRACING_ACTIVATED) {
            StringBuilder traceMessage = new StringBuilder("Post processor preference serialization:\n");
            String prefDelimiter = " :\n";
            String newLine = "\n";
            traceMessage.append("org.eclipse.emf.compare.preference.postprocessor.disabled").append(prefDelimiter).append(this.getPreferenceStore().getString("org.eclipse.emf.compare.preference.postprocessor.disabled")).append(newLine);
            EMFCompareRCPPlugin.getDefault().log(1, traceMessage.toString());
        }
        return super.performOk();
    }

    protected void performDefaults() {
        LinkedHashSet descriptors = Sets.newLinkedHashSet((Iterable)EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry().getItemDescriptors());
        this.interactiveUI.checkElements(descriptors.toArray(new IItemDescriptor[descriptors.size()]));
        this.dataHolder.setData(descriptors);
        super.performDefaults();
    }

    private void setEnginePreferences(String preferenceKey, Set<IItemDescriptor<IPostProcessor.Descriptor>> currentSelectedEngines) {
        if (currentSelectedEngines != null && currentSelectedEngines.size() > 0) {
            Iterable identifiers = Iterables.transform(currentSelectedEngines, (Function)new Function<IItemDescriptor<?>, String>(){

                public String apply(IItemDescriptor<?> desc) {
                    return desc.getID();
                }
            });
            String descriptorsKey = Joiner.on((String)";").join(identifiers);
            this.getPreferenceStore().setValue(preferenceKey, descriptorsKey);
        } else {
            this.getPreferenceStore().setToDefault(preferenceKey);
        }
    }
}

