/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.RowGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.reorder.command.RowReorderCommand;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GroupRowReorderCommandHandler
extends AbstractLayerCommandHandler<RowReorderCommand> {
    private final RowGroupHeaderLayer rowGroupHeaderLayer;

    public GroupRowReorderCommandHandler(RowGroupHeaderLayer rowGroupHeaderLayer) {
        this.rowGroupHeaderLayer = rowGroupHeaderLayer;
    }

    @Override
    protected boolean doCommand(RowReorderCommand command) {
        boolean reorderToTopEdge;
        int toRowPosition;
        int fromRowPosition = command.getFromRowPosition();
        boolean isValid = RowGroupUtils.isReorderValid(this.rowGroupHeaderLayer, fromRowPosition, toRowPosition = command.getToRowPosition(), reorderToTopEdge = command.isReorderToTopEdge());
        if (isValid) {
            int fromIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(fromRowPosition);
            int toIndex = this.rowGroupHeaderLayer.getPositionLayer().getRowIndexByPosition(toRowPosition);
            SelectionLayer.MoveDirectionEnum moveDirection = PositionUtil.getVerticalMoveDirection(fromRowPosition, toRowPosition);
            int fromPositionToCheck = fromRowPosition;
            int toPositionToCheck = toRowPosition;
            if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                --toPositionToCheck;
            }
            boolean toggleCoordinateByEdge = false;
            GroupModel.Group groupToEnd = null;
            GroupModel.Group groupToStart = null;
            int level = 0;
            while (level < this.rowGroupHeaderLayer.getLevelCount()) {
                GroupModel.Group fromGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, fromPositionToCheck);
                GroupModel.Group toGroup = this.rowGroupHeaderLayer.getGroupByPosition(level, toPositionToCheck);
                if (fromGroup != null && fromGroup.isCollapsed() && (!RowGroupUtils.isInTheSameGroup(this.rowGroupHeaderLayer, level, fromPositionToCheck, toPositionToCheck) || fromPositionToCheck == toPositionToCheck)) {
                    this.rowGroupHeaderLayer.expandGroup(this.rowGroupHeaderLayer.getGroupModel(level), fromGroup);
                    if (moveDirection != SelectionLayer.MoveDirectionEnum.DOWN) {
                        fromPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(fromIndex);
                        command.updateFromRowPosition(fromPositionToCheck);
                    } else {
                        fromPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(fromIndex);
                        command.updateFromRowPosition(fromPositionToCheck);
                        toPositionToCheck = this.rowGroupHeaderLayer.getPositionLayer().getRowPositionByIndex(toIndex);
                        command.updateToRowPosition(toPositionToCheck);
                        if (SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && reorderToTopEdge) {
                            --toPositionToCheck;
                        }
                    }
                }
                if (toGroup != null && SelectionLayer.MoveDirectionEnum.DOWN == moveDirection && toGroup.isGroupEnd(toPositionToCheck)) {
                    toggleCoordinateByEdge = true;
                    if (toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                        groupToEnd = toGroup;
                    }
                } else if (toGroup != null && SelectionLayer.MoveDirectionEnum.UP == moveDirection && toGroup.isGroupStart(toPositionToCheck) && toGroup.isUnbreakable() && toGroup.getVisibleSpan() < toGroup.getOriginalSpan()) {
                    groupToStart = toGroup;
                }
                ++level;
            }
            if (toggleCoordinateByEdge) {
                command.toggleCoordinateByEdge();
            }
            if (groupToEnd != null) {
                return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new RowReorderToGroupEndCommand(command, groupToEnd));
            }
            if (groupToStart != null) {
                return this.rowGroupHeaderLayer.getPositionLayer().getUnderlyingLayerByPosition(0, 0).doCommand(new RowReorderToGroupStartCommand(command, groupToStart));
            }
        }
        return !isValid;
    }

    @Override
    public Class<RowReorderCommand> getCommandClass() {
        return RowReorderCommand.class;
    }

    class RowReorderToGroupEndCommand
    extends RowReorderCommand {
        private final GroupModel.Group group;

        public RowReorderToGroupEndCommand(RowReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected RowReorderToGroupEndCommand(RowReorderToGroupEndCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupEndPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && !this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupEndPosition = this.group.getGroupEndPosition((IUniqueIndexLayer)targetLayer)) >= 0 && groupEndPosition > this.getToRowPosition()) {
                this.updateToRowPosition(groupEndPosition);
            }
            return convert;
        }

        @Override
        public RowReorderToGroupEndCommand cloneCommand() {
            return new RowReorderToGroupEndCommand(this);
        }
    }

    class RowReorderToGroupStartCommand
    extends RowReorderCommand {
        private final GroupModel.Group group;

        public RowReorderToGroupStartCommand(RowReorderCommand command, GroupModel.Group group) {
            super(command);
            this.group = group;
        }

        protected RowReorderToGroupStartCommand(RowReorderToGroupStartCommand command) {
            super(command);
            this.group = command.group;
        }

        @Override
        public boolean convertToTargetLayer(ILayer targetLayer) {
            int groupStartPosition;
            boolean convert = super.convertToTargetLayer(targetLayer);
            if (convert && this.isReorderToTopEdge() && targetLayer instanceof IUniqueIndexLayer && (groupStartPosition = ((IUniqueIndexLayer)targetLayer).getRowPositionByIndex(this.group.getStartIndex())) >= 0 && groupStartPosition < this.getToRowPosition()) {
                this.updateToRowPosition(groupStartPosition);
            }
            return convert;
        }

        @Override
        public RowReorderToGroupStartCommand cloneCommand() {
            return new RowReorderToGroupStartCommand(this);
        }
    }
}

