/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.performance.action;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupUtils;
import org.eclipse.nebula.widgets.nattable.group.performance.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.GroupModel;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.reorder.action.ColumnReorderDragMode;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnHeaderReorderDragMode
extends ColumnReorderDragMode {
    private final ColumnGroupHeaderLayer columnGroupHeaderLayer;
    protected int dragFromGridRowPosition;

    public ColumnHeaderReorderDragMode(ColumnGroupHeaderLayer columnGroupHeaderLayer) {
        this.columnGroupHeaderLayer = columnGroupHeaderLayer;
    }

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        super.mouseDown(natTable, event);
        ILayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(this.initialEvent.x), natTable.getRowPositionByY(this.initialEvent.y));
        this.dragFromGridRowPosition = cell != null ? cell.getOriginRowPosition() + cell.getRowSpan() - 1 : -1;
    }

    @Override
    public boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition) {
        if (this.currentEvent != null) {
            CellEdgeEnum moveDirection = this.getMoveDirection(this.currentEvent.x);
            toGridColumnPosition = this.getDragToGridColumnPosition(moveDirection, this.natTable.getColumnPositionByX(this.currentEvent.x));
        }
        int toPosition = LayerUtil.convertColumnPosition(natLayer, toGridColumnPosition, this.columnGroupHeaderLayer.getPositionLayer());
        int fromPosition = this.columnGroupHeaderLayer.getReorderFromColumnPosition();
        int level = 0;
        while (level < this.columnGroupHeaderLayer.getLevelCount()) {
            if (!this.isValidTargetColumnPosition(natLayer, fromGridColumnPosition, toGridColumnPosition, level, fromPosition, toPosition)) {
                return false;
            }
            ++level;
        }
        return true;
    }

    protected boolean isValidTargetColumnPosition(ILayer natLayer, int fromGridColumnPosition, int toGridColumnPosition, int level, int fromPosition, int toPosition) {
        GroupModel model = this.columnGroupHeaderLayer.getGroupModel(level);
        if (model.isPartOfAnUnbreakableGroup(fromPosition) && model.getGroupByPosition(fromPosition).getOriginalSpan() > 1) {
            SelectionLayer.MoveDirectionEnum moveDirection;
            int toCheck = toPosition;
            toCheck = toPosition < 0 && toGridColumnPosition == natLayer.getColumnCount() ? LayerUtil.convertColumnPosition(natLayer, toGridColumnPosition - 1, this.columnGroupHeaderLayer.getPositionLayer()) : (SelectionLayer.MoveDirectionEnum.RIGHT == (moveDirection = PositionUtil.getHorizontalMoveDirection(fromPosition, toCheck)) ? toCheck - 1 : toCheck);
            return ColumnGroupUtils.isInTheSameGroup(this.columnGroupHeaderLayer, level, fromPosition, toCheck);
        }
        boolean betweenTwoGroups = false;
        if (this.currentEvent != null) {
            int minX = this.currentEvent.x - 4;
            int maxX = this.currentEvent.x + 4;
            betweenTwoGroups = ColumnGroupUtils.isBetweenTwoGroups(natLayer, minX, maxX, this.columnGroupHeaderLayer, level);
        }
        return betweenTwoGroups || !model.isPartOfAnUnbreakableGroup(toPosition);
    }

    @Override
    protected CellEdgeEnum getMoveDirection(int x) {
        ILayerCell cell = this.getColumnCell(x);
        if (cell != null) {
            Rectangle selectedColumnHeaderRect = cell.getBounds();
            return CellEdgeDetectUtil.getHorizontalCellEdge(selectedColumnHeaderRect, new Point(x, this.natTable.getStartYOfRowPosition(this.dragFromGridRowPosition)));
        }
        return null;
    }

    @Override
    protected ILayerCell getColumnCell(int x) {
        int gridColumnPosition = this.natTable.getColumnPositionByX(x);
        return this.natTable.getCellByPosition(gridColumnPosition, this.dragFromGridRowPosition);
    }
}

