/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.AttributeChangeItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.SafeAdapterFactoryItemDelegator;
import org.eclipse.emf.compare.provider.spec.OverlayImageProvider;
import org.eclipse.emf.compare.provider.spec.ReferenceChangeItemProviderSpec;
import org.eclipse.emf.compare.provider.spec.Strings;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemFontProvider;

public class AttributeChangeItemProviderSpec
extends AttributeChangeItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider,
ISemanticObjectLabelProvider {
    private static final int ELIDE_LENGTH = 50;
    private final OverlayImageProvider overlayProvider;
    private final AdapterFactoryItemDelegator itemDelegator = new SafeAdapterFactoryItemDelegator(this.getRootAdapterFactory());

    public AttributeChangeItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.overlayProvider = new OverlayImageProvider(this.getResourceLocator());
    }

    @Override
    public Object getImage(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        Object attributeChangeValueImage = this.itemDelegator.getImage(attributeChange.getValue());
        if (attributeChangeValueImage == null) {
            attributeChangeValueImage = super.getImage(object);
        }
        Object diffImage = this.overlayProvider.getComposedImage((Diff)attributeChange, attributeChangeValueImage);
        Object ret = this.overlayImage(object, diffImage);
        return ret;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    protected String getAttributeText(AttributeChange attChange) {
        return attChange.getAttribute().getName();
    }

    protected String getValueText(AttributeChange attChange) {
        return this.getValueText(attChange.getValue(), attChange.getAttribute());
    }

    protected String getValueText(Object attValue, EAttribute attribute) {
        FeatureMap.Entry entry;
        EStructuralFeature entryFeature;
        String value = FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute) ? ((entryFeature = (entry = (FeatureMap.Entry)attValue).getEStructuralFeature()) instanceof EAttribute ? EcoreUtil.convertToString((EDataType)((EAttribute)entryFeature).getEAttributeType(), (Object)attValue) : this.itemDelegator.getText(entry.getValue())) : EcoreUtil.convertToString((EDataType)attribute.getEAttributeType(), (Object)attValue);
        if (com.google.common.base.Strings.isNullOrEmpty((String)value)) {
            value = attValue instanceof EObject && ((EObject)attValue).eIsProxy() ? "proxy : " + ((InternalEObject)attValue).eProxyURI().toString() : "<null>";
        } else {
            value = Strings.removeLineBreaks(value);
            value = Strings.elide(value, 50, "...");
        }
        return value;
    }

    public Object getForeground(Object object) {
        AttributeChange attributeChange = (AttributeChange)object;
        switch (attributeChange.getState()) {
            case MERGED: 
            case DISCARDED: {
                return URI.createURI((String)"color://rgb/156/156/156");
            }
        }
        return super.getForeground(object);
    }

    @Override
    public IStyledString.IComposedStyledString getStyledText(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        ComposedStyledString ret = new ComposedStyledString();
        Object attChangeValue = attChange.getValue();
        if (attChangeValue instanceof EObject && ((EObject)attChangeValue).eIsProxy()) {
            IStyledString.Style italic = IStyledString.Style.builder().setFont(IItemFontProvider.ITALIC_FONT).build();
            ret.append(valueText, italic);
        } else {
            ret.append(valueText);
        }
        ret.append(" [" + attributeText, IStyledString.Style.DECORATIONS_STYLER);
        switch (attChange.getKind()) {
            case ADD: {
                ret.append(" add", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case DELETE: {
                ret.append(" delete", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case CHANGE: {
                ret.append(" " + ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute()), IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            case MOVE: {
                ret.append(" move", IStyledString.Style.DECORATIONS_STYLER);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        ret.append("]", IStyledString.Style.DECORATIONS_STYLER);
        return ret;
    }

    @Override
    public String getSemanticObjectLabel(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        return this.getValueText(attChange);
    }

    @Override
    public String getDescription(Object object) {
        AttributeChange attChange = (AttributeChange)object;
        String valueText = this.getValueText(attChange);
        String attributeText = this.getAttributeText(attChange);
        String hasBeenAndSide = EMFCompareEditMessages.getString("change.local");
        if (attChange.getSource() == DifferenceSource.RIGHT) {
            hasBeenAndSide = EMFCompareEditMessages.getString("change.remote");
        }
        String ret = "";
        switch (attChange.getKind()) {
            case ADD: {
                ret = EMFCompareEditMessages.getString("AttributeChangeItemProviderSpec.valueAdded", valueText, hasBeenAndSide, attributeText);
                break;
            }
            case DELETE: {
                ret = EMFCompareEditMessages.getString("AttributeChangeItemProviderSpec.valueRemoved", valueText, hasBeenAndSide, attributeText);
                break;
            }
            case CHANGE: {
                String changeText = ReferenceChangeItemProviderSpec.changeText((Diff)attChange, (EStructuralFeature)attChange.getAttribute());
                ret = EMFCompareEditMessages.getString("AttributeChangeItemProviderSpec.valueChanged", attributeText, valueText, hasBeenAndSide, changeText);
                break;
            }
            case MOVE: {
                ret = EMFCompareEditMessages.getString("AttributeChangeItemProviderSpec.valueMoved", valueText, hasBeenAndSide, attributeText);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported " + DifferenceKind.class.getSimpleName() + " value: " + attChange.getKind());
            }
        }
        return ret;
    }
}

