/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor;

import com.google.inject.Inject;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.fordiac.ide.gef.commands.OperationHistoryCommandStack;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.fordiac.ide.typeeditor.Messages;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorMessageOutline;
import org.eclipse.fordiac.ide.typeeditor.XtextTypeEditorPageNavigationLocation;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IUndoManagerExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class XtextTypeEditorPage
extends XtextEditor
implements ITypeEditorPage {
    @Inject
    private AbstractUIPlugin languageUIPlugin;
    private boolean restoringSelection;
    private boolean performanceMode;
    private boolean performanceModeShowDialog;
    private IUndoContext typeEditorUndoContext;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setupUndoContext();
        this.checkPerformanceMode();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setupUndoContext();
    }

    public void reveal(int offset, int length) {
        this.revealEditor();
        super.reveal(offset, length);
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        if (!this.restoringSelection) {
            this.revealEditor();
        }
        super.selectAndReveal(selectionStart, selectionLength, revealStart, revealLength);
    }

    protected void restoreSelection() {
        this.restoringSelection = true;
        try {
            super.restoreSelection();
        }
        finally {
            this.restoringSelection = false;
        }
    }

    public CommandStack getCommandStack() {
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            return (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == IContentOutlinePage.class && this.performanceMode) {
            return adapter.cast((Object)new TypeEditorMessageOutline(Messages.XtextTypeEditorPage_PerformanceModeOutlineMessage));
        }
        return (T)super.getAdapter(adapter);
    }

    public void setFocus() {
        if (this.performanceModeShowDialog) {
            this.performanceModeShowDialog = false;
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.XtextTypeEditorPage_PerformanceModeDialogTitle, (String)Messages.XtextTypeEditorPage_PerformanceModeDialogMessage);
        }
        super.setFocus();
    }

    protected void checkPerformanceMode() {
        if (this.performanceMode) {
            return;
        }
        if (this.shouldEnablePerformanceMode()) {
            this.enablePerformanceMode();
        }
    }

    protected boolean shouldEnablePerformanceMode() {
        return false;
    }

    protected void enablePerformanceMode() {
        this.performanceMode = true;
        this.performanceModeShowDialog = true;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ProjectionViewer) {
            ProjectionViewer projectionViewer = (ProjectionViewer)iSourceViewer;
            projectionViewer.disableProjection();
        }
        this.uninstallFoldingSupport();
        this.uninstallHighlightingHelper();
        ISourceViewer iSourceViewer2 = this.getSourceViewer();
        if (iSourceViewer2 instanceof SourceViewer) {
            SourceViewer sourceViewer = (SourceViewer)iSourceViewer2;
            sourceViewer.setCodeMiningProviders(null);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    @Override
    public boolean outlineSelectionChanged(Object selectedElement) {
        return false;
    }

    @Override
    public boolean isMarkerTarget(IMarker marker) {
        try {
            return marker.getType().startsWith(this.languageUIPlugin.getBundle().getSymbolicName() + "." + this.getLanguageShortName().toLowerCase());
        }
        catch (CoreException e) {
            return false;
        }
    }

    protected String getLanguageShortName() {
        String languageName = this.getLanguageName();
        return languageName.substring(languageName.lastIndexOf(46) + 1);
    }

    @Override
    public void reloadType() {
        this.doRevertToSaved();
        this.setupUndoContext();
    }

    protected void handleEditorInputChanged() {
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    @Override
    public Object getSelectableObject() {
        return null;
    }

    protected void markInNavigationHistory() {
        IEditorSite iEditorSite = this.getEditorSite();
        if (iEditorSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iEditorSite;
            this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)multiPageEditorSite.getMultiPageEditor());
        } else {
            super.markInNavigationHistory();
        }
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new XtextTypeEditorPageNavigationLocation(this, false);
    }

    public INavigationLocation createNavigationLocation() {
        return new XtextTypeEditorPageNavigationLocation(this, true);
    }

    protected void setupUndoContext() {
        IUndoContext iUndoContext = this.getUndoContext();
        if (iUndoContext instanceof ObjectUndoContext) {
            CommandStack commandStack;
            ObjectUndoContext objectUndoContext = (ObjectUndoContext)iUndoContext;
            if (this.typeEditorUndoContext != null) {
                objectUndoContext.removeMatch(this.typeEditorUndoContext);
            }
            if ((commandStack = this.getCommandStack()) instanceof OperationHistoryCommandStack) {
                OperationHistoryCommandStack operationHistoryCommandStack = (OperationHistoryCommandStack)commandStack;
                this.typeEditorUndoContext = operationHistoryCommandStack.getUndoContext();
            }
            if (this.typeEditorUndoContext != null && !objectUndoContext.matches(this.typeEditorUndoContext)) {
                objectUndoContext.addMatch(this.typeEditorUndoContext);
            }
        }
    }

    protected IUndoContext getUndoContext() {
        ITextViewerExtension6 textViewerExtension;
        IUndoManager iUndoManager;
        ISourceViewer iSourceViewer = this.getSourceViewer();
        if (iSourceViewer instanceof ITextViewerExtension6 && (iUndoManager = (textViewerExtension = (ITextViewerExtension6)iSourceViewer).getUndoManager()) instanceof IUndoManagerExtension) {
            IUndoManagerExtension undoManagerExtension = (IUndoManagerExtension)iUndoManager;
            return undoManagerExtension.getUndoContext();
        }
        return null;
    }
}

