/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import java.text.MessageFormat;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class AdjustConnectionCommand
extends Command {
    private final Point connStart;
    private final Point connEnd;
    private final Point point;
    private final int index;
    private final Connection modelConnection;
    private final ConnectionRoutingData oldRoutingData;
    private ConnectionRoutingData newRoutingData;

    public AdjustConnectionCommand(Connection modelConnection, Point connStart, Point connEnd, Point p, int index) {
        this.modelConnection = modelConnection;
        this.connStart = connStart;
        this.connEnd = connEnd;
        this.point = p;
        this.index = index;
        this.oldRoutingData = modelConnection.getRoutingData();
    }

    public void execute() {
        this.createInitalNewRoutingData();
        this.updateNewRoutingData();
        this.updateRoutingData(this.newRoutingData);
    }

    public void undo() {
        this.updateRoutingData(this.oldRoutingData);
    }

    public void redo() {
        this.updateRoutingData(this.newRoutingData);
    }

    private void updateRoutingData(ConnectionRoutingData routingData) {
        this.modelConnection.setRoutingData(routingData);
    }

    private void updateNewRoutingData() {
        switch (this.index) {
            case 2: {
                int newDx1 = Math.max(this.point.x - this.connStart.x, 12);
                if (this.newRoutingData.is3SegementData()) {
                    newDx1 = Math.min(newDx1, this.connEnd.x - this.connStart.x - 12);
                }
                this.newRoutingData.setDx1(AdjustConnectionCommand.fromScreen(newDx1));
                break;
            }
            case 4: {
                this.newRoutingData.setDy(AdjustConnectionCommand.fromScreen(this.point.y - this.connStart.y));
                break;
            }
            case 6: {
                int newDx2 = Math.max(this.connEnd.x - this.point.x, 12);
                this.newRoutingData.setDx2(AdjustConnectionCommand.fromScreen(newDx2));
                break;
            }
            default: {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.AdjustConnectionCommand_WrongConnectionSegmentIndex, this.index));
            }
        }
    }

    private void createInitalNewRoutingData() {
        this.newRoutingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        this.newRoutingData.setDx1(this.oldRoutingData.getDx1());
        this.newRoutingData.setDx2(this.oldRoutingData.getDx2());
        this.newRoutingData.setDy(this.oldRoutingData.getDy());
    }

    private static double fromScreen(int val) {
        return CoordinateConverter.INSTANCE.screenToIEC61499(val);
    }
}

