/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerDataType;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.LiveSearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.LibraryElementSearchContext;
import org.eclipse.fordiac.ide.model.search.types.SearchChildrenProviderHelper;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class DataTypeInstanceSearch
extends IEC61499ElementSearch {
    public DataTypeInstanceSearch(DataTypeEntry dtEntry) {
        super(new LiveSearchContext(dtEntry.getTypeLibrary()), DataTypeInstanceSearch.createSearchFilter((TypeEntry)dtEntry), new DataTypeInstanceSearchChildrenProvider());
    }

    public DataTypeInstanceSearch(ErrorTypeEntry dtEntry, TypeLibrary library) {
        super(new LiveSearchContext(library), DataTypeInstanceSearch.createSearchFilter((TypeEntry)dtEntry), new DataTypeInstanceSearchChildrenProvider());
    }

    public DataTypeInstanceSearch(LibraryElement typeEditable, DataTypeEntry dtEntry) {
        super(new LibraryElementSearchContext(typeEditable), DataTypeInstanceSearch.createSearchFilter((TypeEntry)dtEntry), new DataTypeInstanceSearchChildrenProvider());
    }

    private static IEC61499SearchFilter createSearchFilter(TypeEntry dtEntry) {
        return searchCandidate -> {
            Attribute attr;
            ConfigurableFB configFb;
            VarDeclaration varDecl;
            return searchCandidate instanceof VarDeclaration && dtEntry == (varDecl = (VarDeclaration)searchCandidate).getType().getTypeEntry() || searchCandidate instanceof ConfigurableFB && DataTypeInstanceSearch.isConfiguredWithDataType(configFb = (ConfigurableFB)searchCandidate, dtEntry) || searchCandidate instanceof Attribute && (attr = (Attribute)searchCandidate).getType().getTypeEntry() == dtEntry;
        };
    }

    private static boolean isConfiguredWithDataType(ConfigurableFB confFB, TypeEntry dtEntry) {
        if (confFB.getDataType() == null || confFB.getDataType().getTypeEntry() == null) {
            return false;
        }
        if (confFB.getDataType() instanceof ErrorMarkerDataType || dtEntry.getType() instanceof ErrorMarkerDataType) {
            return confFB.getDataType().getTypeEntry().getFullTypeName().equals(dtEntry.getFullTypeName());
        }
        return dtEntry == confFB.getDataType().getTypeEntry();
    }

    private static final class DataTypeInstanceSearchChildrenProvider
    implements ISearchChildrenProvider {
        private DataTypeInstanceSearchChildrenProvider() {
        }

        @Override
        public boolean hasChildren(EObject obj) {
            return obj instanceof FBType || obj instanceof AutomationSystem || obj instanceof UntypedSubApp || obj instanceof StructuredType || obj instanceof AttributeDeclaration || obj instanceof Application || obj instanceof Attribute || obj instanceof FBNetworkElement || obj instanceof IInterfaceElement;
        }

        @Override
        public Stream<? extends EObject> getChildren(EObject obj) {
            if (obj instanceof FBType) {
                FBType fbType = (FBType)obj;
                return SearchChildrenProviderHelper.getFBTypeChildren(fbType);
            }
            if (obj instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)obj;
                return Stream.concat(system.getAttributes().stream(), system.getApplication().stream());
            }
            if (obj instanceof Application) {
                Application application = (Application)obj;
                Stream stream = application.getFBNetwork().getNetworkElements().stream();
                stream = Stream.concat(stream, application.getFBNetwork().getAdapterConnections().stream());
                stream = Stream.concat(stream, application.getFBNetwork().getDataConnections().stream());
                stream = Stream.concat(stream, application.getFBNetwork().getEventConnections().stream());
                return Stream.concat(stream, application.getAttributes().stream());
            }
            if (obj instanceof UntypedSubApp) {
                UntypedSubApp untypedSubapp = (UntypedSubApp)obj;
                return SearchChildrenProviderHelper.getUntypedSubappChildren(untypedSubapp);
            }
            if (obj instanceof StructuredType) {
                StructuredType structType = (StructuredType)obj;
                return SearchChildrenProviderHelper.getStructChildren(structType);
            }
            if (obj instanceof AttributeDeclaration) {
                AttributeDeclaration attrdecl = (AttributeDeclaration)obj;
                return SearchChildrenProviderHelper.getAttributeDeclChildren(attrdecl);
            }
            if (obj instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement elem = (BlockFBNetworkElement)obj;
                return Stream.concat(elem.getAttributes().stream(), SearchChildrenProviderHelper.getInterfaceListChildren(elem.getInterface()));
            }
            if (obj instanceof IInterfaceElement) {
                IInterfaceElement interfaceElement = (IInterfaceElement)obj;
                return interfaceElement.getAttributes().stream();
            }
            if (obj instanceof Attribute) {
                Attribute atrr = (Attribute)obj;
                return Stream.of(atrr.getType());
            }
            if (obj instanceof ConfigurableObject) {
                ConfigurableObject object = (ConfigurableObject)obj;
                return object.getAttributes().stream();
            }
            return Stream.empty();
        }
    }
}

