/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.DoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

final class ImmutableDoubleEmptyStack
implements ImmutableDoubleStack,
Serializable {
    static final ImmutableDoubleStack INSTANCE = new ImmutableDoubleEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableDoubleEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public void each(DoubleProcedure procedure) {
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public double peek() {
        throw new EmptyStackException();
    }

    public DoubleList peek(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return new DoubleArrayList(0);
        }
        throw new EmptyStackException();
    }

    public double peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    public ImmutableDoubleStack select(DoublePredicate predicate) {
        return this;
    }

    public ImmutableDoubleStack reject(DoublePredicate predicate) {
        return this;
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public <V> ImmutableStack<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    public double sum() {
        return 0.0;
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public double[] toArray() {
        return new double[0];
    }

    public double[] toArray(double[] target) {
        return target;
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableDoubleStack toImmutable() {
        return this;
    }

    public ImmutableDoubleStack push(double element) {
        return DoubleStacks.immutable.with(element);
    }

    public ImmutableDoubleStack pop() {
        throw new EmptyStackException();
    }

    public ImmutableDoubleStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof DoubleStack)) {
            return false;
        }
        DoubleStack stack = (DoubleStack)otherStack;
        return stack.isEmpty();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(double value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectDoubleIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(DoubleIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public MutableDoubleStack toStack() {
        return DoubleStacks.mutable.empty();
    }
}

