/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.description;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.sirius.business.internal.migration.description.VSMMigrationService;
import org.eclipse.sirius.business.internal.migration.description.VSMVersionSAXParser;
import org.osgi.framework.Version;

public class VSMXMIHelper
extends XMIHelperImpl {
    private String version;
    private boolean migrationNeeded;

    public VSMXMIHelper(XMLResource resource) {
        super(resource);
        VSMVersionSAXParser parser = new VSMVersionSAXParser(resource.getURI());
        this.version = parser.getVersion((IProgressMonitor)new NullProgressMonitor());
        this.migrationNeeded = VSMMigrationService.getInstance().isMigrationNeeded(Version.parseVersion((String)this.version));
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        Object newValue = null;
        if (this.migrationNeeded) {
            newValue = VSMMigrationService.getInstance().getValue(object, feature, value, this.version);
        }
        if (newValue != null) {
            super.setValue(object, feature, newValue, position);
        } else {
            super.setValue(object, feature, value, position);
        }
    }

    public EObject createObject(EFactory eFactory, EClassifier type) {
        EFactory factory = eFactory;
        if (this.migrationNeeded && type != null && type.getEPackage() != null && type.getEPackage().getEFactoryInstance() != null) {
            factory = type.getEPackage().getEFactoryInstance();
        }
        EObject newObject = super.createObject(factory, type);
        if (this.migrationNeeded) {
            newObject = VSMMigrationService.getInstance().updateCreatedObject(newObject, this.version);
        }
        return newObject;
    }
}

