/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.AttributeInheritMode;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.systemconfiguration.CommunicationConfigurationDetails;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.util.ColorHelper;
import org.eclipse.gef.commands.Command;

public class SegmentCreateCommand
extends Command {
    private static final int DEFAULT_SEGMENT_WIDTH = 300;
    private final SegmentTypeEntry type;
    private final SystemConfiguration parent;
    private final Position pos;
    private final int width;
    private Segment segment;

    public SegmentCreateCommand(SegmentTypeEntry type, SystemConfiguration parent, Rectangle bounds) {
        this.type = type;
        this.parent = parent;
        this.pos = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(bounds.x, bounds.y);
        this.width = -1 != bounds.width ? bounds.width : 300;
    }

    public boolean canExecute() {
        return this.parent != null;
    }

    public void execute() {
        this.segment = LibraryElementFactory.eINSTANCE.createSegment();
        this.segment.setColor(ColorHelper.createRandomColor());
        this.segment.setTypeEntry((TypeEntry)this.type);
        CommunicationConfigurationDetails commConfig = CommunicationConfigurationDetails.getCommConfigUiFromExtensionPoint((String)this.type.getTypeName(), (String)"id");
        if (commConfig != null) {
            this.segment.setCommunication(commConfig.createModel((List)this.segment.getVarDeclarations()));
        }
        this.segment.getVarDeclarations().addAll(EcoreUtil.copyAll((Collection)this.type.getType().getVarDeclaration()));
        this.segment.setPosition(this.pos);
        this.segment.setWidth(CoordinateConverter.INSTANCE.screenToIEC61499(this.width));
        this.redo();
        this.segment.setName(NameRepository.createUniqueName((INamedElement)this.segment, (String)this.type.getType().getName()));
        AttributeInheritMode.copyAttributeValuesFromType((TypedConfigureableObject)this.segment);
    }

    public void undo() {
        this.parent.getSegments().remove((Object)this.segment);
    }

    public void redo() {
        this.parent.getSegments().add((Object)this.segment);
    }
}

