/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.document;

import com.google.inject.Inject;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.LibraryElementXtextDocumentProvider;
import org.eclipse.fordiac.ide.structuredtextcore.ui.document.STCoreDocumentPartitioner;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCorePartition;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreReconciler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

public class STCoreDocumentProvider
extends LibraryElementXtextDocumentProvider {
    @Inject
    private STCoreDocumentPartitioner partitioner;
    @Inject
    private STCoreReconciler reconciler;

    @Override
    public void setDocumentContent(IDocument document, LibraryElement element) {
        document.set(this.partitioner.combine(element));
    }

    @Override
    public void doSaveDocument(IProgressMonitor monitor, IFileEditorInput fileEditorInput, LibraryElement element, XtextDocument document) throws CoreException {
        monitor.beginTask("Saving", 2);
        try {
            monitor.subTask("Partitioning");
            Optional<STCorePartition> partition = this.partitioner.partition(document);
            monitor.worked(1);
            monitor.subTask("Reconciling");
            if (partition.isPresent()) {
                Display.getDefault().syncExec(() -> this.reconciler.reconcile(element, partition));
            }
        }
        finally {
            monitor.done();
        }
    }
}

