/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.st.AttributeEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.DirectlyDerivedTypeEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.ECTransitionEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.STAlgorithmEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.STFunctionBodyEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.STFunctionEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.STMethodEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.ScopedExpressionEvaluator;
import org.eclipse.fordiac.ide.model.eval.st.VarDeclarationEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;

public class StructuredTextEvaluatorFactory
implements EvaluatorFactory {
    public Evaluator createEvaluator(Object source, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        if (source instanceof STAlgorithm) {
            STAlgorithm algorithm = (STAlgorithm)source;
            return new STAlgorithmEvaluator(algorithm, context, variables, parent);
        }
        if (source instanceof ECTransition) {
            ECTransition transition = (ECTransition)source;
            return new ECTransitionEvaluator(transition, context, variables, parent);
        }
        if (source instanceof org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod) {
            org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod method = (org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod)source;
            return new STMethodEvaluator(method, context, variables, parent);
        }
        if (source instanceof STMethod) {
            STMethod libMethod = (STMethod)source;
            return new STMethodEvaluator(libMethod, context, variables, parent);
        }
        if (source instanceof STFunction) {
            STFunction function = (STFunction)source;
            return new STFunctionEvaluator(function, context, variables, parent);
        }
        if (source instanceof STFunctionBody) {
            STFunctionBody functionBody = (STFunctionBody)source;
            return new STFunctionBodyEvaluator(functionBody, context, variables, parent);
        }
        if (source instanceof String) {
            String string = (String)source;
            return new ScopedExpressionEvaluator(string, context, variables, parent);
        }
        if (source instanceof VarDeclaration) {
            VarDeclaration varDeclaration = (VarDeclaration)source;
            return new VarDeclarationEvaluator(varDeclaration, context, variables, parent);
        }
        if (source instanceof Attribute) {
            Attribute attribute = (Attribute)source;
            return new AttributeEvaluator(attribute, context, variables, parent);
        }
        if (source instanceof DirectlyDerivedType) {
            DirectlyDerivedType directlyDerivedType = (DirectlyDerivedType)source;
            return new DirectlyDerivedTypeEvaluator(directlyDerivedType, context, variables, parent);
        }
        return null;
    }

    public static void register() {
        StructuredTextEvaluatorFactory factory = new StructuredTextEvaluatorFactory();
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", STAlgorithm.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", ECTransition.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", STMethod.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", STFunction.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", STFunctionBody.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", String.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", VarDeclaration.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", Attribute.class, (EvaluatorFactory)factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", DirectlyDerivedType.class, (EvaluatorFactory)factory);
    }
}

