/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TextDirectEditManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class LabelDirectEditManager
extends TextDirectEditManager {
    private final Label label;
    private String initialString = null;
    private VerifyListener aditionalVerify = null;

    public LabelDirectEditManager(GraphicalEditPart source, Label label) {
        this(source, label, null);
    }

    public LabelDirectEditManager(GraphicalEditPart source, Label label, VerifyListener aditionalVerifyListener) {
        super(source, new FigureCellEditorLocator((IFigure)label));
        this.label = label;
        this.aditionalVerify = aditionalVerifyListener;
    }

    public void show(char initialChar) {
        this.initialString = new String(new char[]{initialChar});
        this.show();
        Text textControl = (Text)this.getCellEditor().getControl();
        textControl.setSelection(1);
        this.setDirty(true);
        this.getLocator().relocate(this.getCellEditor());
    }

    @Override
    protected void bringDown() {
        this.initialString = null;
        super.bringDown();
    }

    @Override
    protected void initCellEditor() {
        super.initCellEditor();
        Text text = (Text)this.getCellEditor().getControl();
        if (this.aditionalVerify != null) {
            text.addVerifyListener(this.aditionalVerify);
        }
        String initialLabelText = "";
        if (this.initialString == null) {
            initialLabelText = this.label.getText();
            this.getCellEditor().setValue((Object)initialLabelText);
        } else {
            initialLabelText = this.initialString;
            this.getCellEditor().setValue((Object)initialLabelText);
        }
        text.selectAll();
    }

    public void setInitialString(String val) {
        this.initialString = val;
        if (this.getCellEditor() != null) {
            this.getCellEditor().setValue((Object)this.initialString);
        }
    }

    @Override
    protected void unhookListeners() {
        super.unhookListeners();
        try {
            Text text = (Text)this.getCellEditor().getControl();
            if (this.aditionalVerify != null) {
                text.removeVerifyListener(this.aditionalVerify);
            }
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }
}

