/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.executors.DynamicTypeLoadDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetResourcesHandler
extends AbstractHandler {
    private static List<Object> getDeviceList(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            return structuredSelection.toList();
        }
        return Collections.emptyList();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object object : GetResourcesHandler.getDeviceList(event)) {
            if (object instanceof EditPart) {
                EditPart editPart = (EditPart)object;
                object = editPart.getModel();
            }
            if (!(object instanceof Device)) continue;
            Device device = (Device)object;
            GetResourcesHandler.fetchResources(device);
        }
        return null;
    }

    private static void fetchResources(Device device) {
        IDeviceManagementInteractor interactor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device);
        if (interactor instanceof DynamicTypeLoadDeploymentExecutor) {
            DynamicTypeLoadDeploymentExecutor dynamicTypeLoadDeploymentExecutor = (DynamicTypeLoadDeploymentExecutor)interactor;
            try {
                try {
                    interactor.connect();
                    dynamicTypeLoadDeploymentExecutor.queryResourcesWithNetwork(device);
                }
                catch (Exception e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    try {
                        interactor.disconnect();
                    }
                    catch (DeploymentException e2) {
                        FordiacLogHelper.logError((String)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    interactor.disconnect();
                }
                catch (DeploymentException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

