/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditor;
import org.eclipse.fordiac.ide.model.edit.AbstractTypeEntryAdapter;
import org.eclipse.fordiac.ide.model.edit.Messages;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartService;

public class BulkEditorTypeEntryAdapter
extends AbstractTypeEntryAdapter {
    private final Set<String> changedFiles = new HashSet<String>();

    public BulkEditorTypeEntryAdapter(BulkEditor editor, IPartService partService) {
        super((IEditorPart)editor, partService);
    }

    /*
     * WARNING - void declaration
     */
    public void notifyChanged(Notification notification) {
        void feature;
        super.notifyChanged(notification);
        Object object = notification.getFeature();
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        if (feature.equals("TYPE_ENTRY_FILE_CONTENT_FEATURE")) {
            Object object2 = notification.getNotifier();
            if (object2 instanceof TypeEntry) {
                TypeEntry tEntry = (TypeEntry)object2;
                this.changedFiles.add(tEntry.getFile().getFullPath().toOSString());
            }
            this.handleFileContentChange();
        }
    }

    protected void reloadEditorType() {
        this.getEditor().reloadType();
        this.changedFiles.clear();
    }

    protected BulkEditor getEditor() {
        return (BulkEditor)super.getEditor();
    }

    protected int openFileChangedDialog() {
        String message;
        String title;
        if (this.changedFiles.size() == 1) {
            title = Messages.TypeEntryEditor_FileChangedTitle;
            message = MessageFormat.format(Messages.TypeEntryEditor_FileChanged_message, this.changedFiles.toArray()[0]);
        } else {
            title = Messages.TypeEntryEditor_FilesChangedTitle;
            message = MessageFormat.format(Messages.TypeEntryEditor_FilesChanged_message, String.join((CharSequence)"\n", this.changedFiles));
        }
        MessageDialog dialog = new MessageDialog(this.getEditor().getSite().getShell(), title, null, message, 3, new String[]{Messages.TypeEntryEditor_RedoSearch_label, Messages.TypeEntryEditor_dontreplace_button_label}, 0);
        return dialog.open();
    }
}

