/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;

public class MedianHeuristic
implements ICrossingMinimizationHeuristic {
    protected final Random random;
    protected Comparator<LNode> weightComparator = (n1, n2) -> {
        if (!n1.hasProperty(InternalProperties.WEIGHT)) {
            return 1;
        }
        if (!n2.hasProperty(InternalProperties.WEIGHT)) {
            return -1;
        }
        Double w1 = (Double)n1.getProperty(InternalProperties.WEIGHT);
        Double w2 = (Double)n2.getProperty(InternalProperties.WEIGHT);
        if (w1 != null && w2 != null) {
            return w1.compareTo(w2);
        }
        if (w1 != null) {
            return -1;
        }
        if (w2 != null) {
            return 1;
        }
        return 0;
    };

    public MedianHeuristic(Random random) {
        this.random = random;
        Math.random();
    }

    @Override
    public boolean alwaysImproves() {
        return false;
    }

    @Override
    public boolean setFirstLayerOrder(LNode[][] order, boolean forwardSweep) {
        int firstIndex = forwardSweep ? 0 : Math.max(0, order.length - 1);
        ArrayList firstLayer = Lists.newArrayList((Object[])order[firstIndex]);
        for (LNode node : firstLayer) {
            node.setProperty(InternalProperties.WEIGHT, this.random.nextDouble());
        }
        Collections.sort(firstLayer, this.weightComparator);
        int index = 0;
        for (LNode node : firstLayer) {
            order[firstIndex][index++] = node;
            node.setProperty(InternalProperties.WEIGHT, index);
        }
        return false;
    }

    @Override
    public boolean minimizeCrossings(LNode[][] order, int freeLayerIndex, boolean forwardSweep, boolean isFirstSweep) {
        ArrayList freeLayer = Lists.newArrayList((Object[])order[freeLayerIndex]);
        this.calculateMedians(freeLayer, forwardSweep ? freeLayerIndex - 1 : freeLayerIndex + 1);
        Collections.sort(freeLayer, this.weightComparator);
        int index = 0;
        for (LNode node : freeLayer) {
            order[freeLayerIndex][index++] = node;
        }
        return false;
    }

    private void calculateMedians(List<LNode> nodes, int referenceLayer) {
        double minWeight = Double.MIN_VALUE;
        double maxWeight = Double.MAX_VALUE;
        ArrayList<LNode> toRevisit = new ArrayList<LNode>();
        for (LNode node : nodes) {
            LNode source;
            LNode target;
            ArrayList<LNode> connectedNodes = new ArrayList<LNode>();
            for (LEdge edge : node.getIncomingEdges()) {
                target = edge.getTarget().getNode();
                source = edge.getSource().getNode();
                if (target.getLayer().id == referenceLayer) {
                    connectedNodes.add(target);
                }
                if (source.getLayer().id != referenceLayer) continue;
                connectedNodes.add(source);
            }
            for (LEdge edge : node.getOutgoingEdges()) {
                target = edge.getTarget().getNode();
                source = edge.getSource().getNode();
                if (target.getLayer().id == referenceLayer) {
                    connectedNodes.add(target);
                }
                if (source.getLayer().id != referenceLayer) continue;
                connectedNodes.add(source);
            }
            if (connectedNodes.isEmpty()) {
                toRevisit.add(node);
                continue;
            }
            Collections.sort(connectedNodes, this.weightComparator);
            double newWeight = (Double)((LNode)((Object)connectedNodes.get(connectedNodes.size() / 2))).getProperty(InternalProperties.WEIGHT);
            node.setProperty(InternalProperties.WEIGHT, newWeight);
            minWeight = Math.min(minWeight, newWeight);
            maxWeight = Math.max(maxWeight, newWeight);
        }
        double avgWeight = (maxWeight + minWeight) / 2.0;
        for (LNode n : toRevisit) {
            n.setProperty(InternalProperties.WEIGHT, avgWeight);
        }
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }
}

