/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.edit;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.commands.change.ChangeValueCommand;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ModelEdit;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class InitialValueEdit
extends ModelEdit<VarDeclaration> {
    private final String newValue;
    private String oldValue;

    public InitialValueEdit(String name, URI elementURI, String newValue) {
        super(name, elementURI, VarDeclaration.class);
        this.newValue = newValue;
    }

    @Override
    protected Command createCommand(VarDeclaration element) {
        return new ChangeValueCommand(element, this.newValue);
    }

    @Override
    public void initializeValidationData(VarDeclaration element, IProgressMonitor pm) {
        this.oldValue = InitialValueEdit.getInitialValue(element);
    }

    @Override
    public RefactoringStatus isValid(VarDeclaration element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        if (!Objects.equals(InitialValueEdit.getInitialValue(element), this.oldValue)) {
            status.addFatalError(Messages.InitialValueChange_InitialValueChanged);
        }
        return status;
    }

    protected static String getInitialValue(VarDeclaration varDeclaration) {
        if (varDeclaration.getValue() != null && varDeclaration.getValue().getValue() != null) {
            return varDeclaration.getValue().getValue();
        }
        return "";
    }
}

