/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.commands;

import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Link;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeleteLinkCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ResourceDeleteCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeviceDeleteCommand
extends Command {
    private final Device device;
    private SystemConfiguration deviceParent;
    private CompoundCommand commands;

    public DeviceDeleteCommand(Device device) {
        this.device = device;
    }

    public void execute() {
        this.deviceParent = (SystemConfiguration)this.device.eContainer();
        this.commands = new CompoundCommand();
        for (Resource resource : this.device.getResource()) {
            this.commands.add((Command)new ResourceDeleteCommand(resource));
        }
        for (Link link : this.device.getInConnections()) {
            this.commands.add((Command)new DeleteLinkCommand(link));
        }
        this.commands.execute();
        this.deviceParent.getDevices().remove((Object)this.device);
    }

    public void undo() {
        this.deviceParent.getDevices().add((Object)this.device);
        this.commands.undo();
    }

    public void redo() {
        this.commands.redo();
        this.deviceParent.getDevices().remove((Object)this.device);
    }
}

