/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.handles;

import java.util.List;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.swt.graphics.Cursor;

public class ResizableHandleKit {
    public static void addHandle(GraphicalEditPart part, List<Handle> handles, int direction) {
        handles.add(ResizableHandleKit.createHandle(part, direction));
    }

    public static void addHandle(GraphicalEditPart part, List<Handle> handles, int direction, DragTracker tracker, Cursor cursor) {
        handles.add(ResizableHandleKit.createHandle(part, direction, tracker, cursor));
    }

    @Deprecated
    public static void addHandles(GraphicalEditPart part, List<Handle> handles) {
        ResizableHandleKit.addMoveHandle(part, handles);
        ResizableHandleKit.addCornerAndSideHandles(part, handles);
    }

    public static void addCornerAndSideHandles(GraphicalEditPart part, List<Handle> handles) {
        handles.add(ResizableHandleKit.createHandle(part, 16));
        handles.add(ResizableHandleKit.createHandle(part, 20));
        handles.add(ResizableHandleKit.createHandle(part, 4));
        handles.add(ResizableHandleKit.createHandle(part, 12));
        handles.add(ResizableHandleKit.createHandle(part, 8));
        handles.add(ResizableHandleKit.createHandle(part, 9));
        handles.add(ResizableHandleKit.createHandle(part, 1));
        handles.add(ResizableHandleKit.createHandle(part, 17));
    }

    public static void addCornerAndSideHandles(GraphicalEditPart part, List<Handle> handles, DragTracker tracker, Cursor cursor) {
        handles.add(ResizableHandleKit.createHandle(part, 16, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 20, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 4, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 12, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 8, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 9, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 1, tracker, cursor));
        handles.add(ResizableHandleKit.createHandle(part, 17, tracker, cursor));
    }

    public static void addMoveHandle(GraphicalEditPart f, List<Handle> handles) {
        handles.add(ResizableHandleKit.moveHandle(f));
    }

    public static void addMoveHandle(GraphicalEditPart f, List<Handle> handles, DragTracker tracker, Cursor cursor) {
        handles.add(ResizableHandleKit.moveHandle(f, tracker, cursor));
    }

    static Handle createHandle(GraphicalEditPart owner, int direction) {
        return new ResizeHandle(owner, direction);
    }

    static Handle createHandle(GraphicalEditPart owner, int direction, DragTracker tracker, Cursor cursor) {
        ResizeHandle handle = new ResizeHandle(owner, direction);
        handle.setDragTracker(tracker);
        handle.setCursor(cursor);
        return handle;
    }

    public static Handle moveHandle(GraphicalEditPart owner) {
        return new MoveHandle(owner);
    }

    public static Handle moveHandle(GraphicalEditPart owner, DragTracker tracker, Cursor cursor) {
        MoveHandle moveHandle = new MoveHandle(owner);
        moveHandle.setDragTracker(tracker);
        moveHandle.setCursor(cursor);
        return moveHandle;
    }

    private ResizableHandleKit() {
        throw new UnsupportedOperationException("Helper class should not be instantiated!");
    }
}

