/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GhostImageFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.gef.utilities.CollisionChangeBoundsRequest;
import org.eclipse.fordiac.ide.gef.utilities.MarginBoundsHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class FBNetworkElementNonResizeableEP
extends ModifiedNonResizeableEditPolicy {
    private final MarginBoundsHelper boundsHelper = new MarginBoundsHelper();
    private GhostImageFigure ghostFigure;

    protected RoundedRectangle createSelectionFeedbackFigure() {
        RoundedRectangle figure = super.createSelectionFeedbackFigure();
        figure.setFill(false);
        figure.setOutline(true);
        figure.setLineWidth(4);
        return figure;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.showChangeBoundsFeedback(request);
        PrecisionRectangle rect = new PrecisionRectangle(super.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        this.ghostFigure.translateToRelative((Translatable)rect);
        this.ghostFigure.setBounds((Rectangle)rect);
        this.ghostFigure.validate();
        if (request instanceof CollisionChangeBoundsRequest) {
            CollisionChangeBoundsRequest collisionBoundsRequest = (CollisionChangeBoundsRequest)request;
            IFigure dragFigure = this.getDragSourceFeedbackFigure();
            Border border = dragFigure.getBorder();
            if (border instanceof ModifiedMoveHandle.SelectionBorder) {
                ModifiedMoveHandle.SelectionBorder border2 = (ModifiedMoveHandle.SelectionBorder)border;
                boolean collision = collisionBoundsRequest.checkCollision(dragFigure.getBounds());
                border2.setColor(collision ? ModifiedMoveHandle.getCollisionColor() : ModifiedMoveHandle.getSelectionColor());
            }
            dragFigure.validate();
        }
    }

    protected IFigure createDragSourceFeedbackFigure() {
        this.boundsHelper.updateMargins(this.getHost().getModel());
        this.ghostFigure = new GhostImageFigure(this.getHostFigure(), 100, null);
        this.addFeedback((IFigure)this.ghostFigure);
        return super.createDragSourceFeedbackFigure();
    }

    protected Rectangle getInitialFeedbackBounds() {
        Rectangle bounds = super.getInitialFeedbackBounds().getCopy();
        this.boundsHelper.expandRectangle(bounds);
        return bounds;
    }

    public void deactivate() {
        super.deactivate();
        this.removeGhostFigure();
    }

    public void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        this.removeGhostFigure();
    }

    private void removeGhostFigure() {
        if (this.ghostFigure != null) {
            this.removeFeedback((IFigure)this.ghostFigure);
            this.ghostFigure = null;
        }
    }
}

