/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fordiac.ide.application.commands.AddElementsToSubAppCommand;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractCreateFBNetworkElementCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;

public class NewSubAppCommand
extends AbstractCreateFBNetworkElementCommand
implements QualNameAffectedCommand {
    private final List<?> parts;
    private final AddElementsToSubAppCommand addElements;
    private Command mapSubappCmd;
    private final Map<INamedElement, String> oldQualNames = new HashMap<INamedElement, String>();
    private final Map<INamedElement, String> newQualNames = new HashMap<INamedElement, String>();

    public NewSubAppCommand(FBNetwork fbNetwork, List<?> selection, Position pos) {
        super(fbNetwork, (FBNetworkElement)LibraryElementFactory.eINSTANCE.createUntypedSubApp(), pos);
        this.getElement().setSubAppNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        this.addElements = new AddElementsToSubAppCommand((SubApp)this.getElement(), selection);
        this.checkMapping(selection);
        this.parts = selection;
    }

    public NewSubAppCommand(FBNetwork fbNetwork, List<?> selection, int x, int y) {
        super(fbNetwork, (FBNetworkElement)LibraryElementFactory.eINSTANCE.createUntypedSubApp(), x, y);
        this.getElement().setSubAppNetwork(LibraryElementFactory.eINSTANCE.createFBNetwork());
        this.addElements = new AddElementsToSubAppCommand((SubApp)this.getElement(), selection);
        this.checkMapping(selection);
        this.parts = selection;
    }

    public boolean canExecute() {
        return super.canExecute() && this.allElementsInSameFBnetwork();
    }

    private boolean allElementsInSameFBnetwork() {
        for (Object o : this.parts) {
            FBNetworkElement networkElement;
            EditPart editPart;
            Object model;
            if (!(o instanceof EditPart) || !((model = (editPart = (EditPart)o).getModel()) instanceof FBNetworkElement) || (networkElement = (FBNetworkElement)model).getFbNetwork() == this.getFBNetwork()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.addElements.getElements().forEach(e -> {
            String string = this.oldQualNames.put((INamedElement)e, e.getQualifiedName());
        });
        super.execute();
        this.addElements.execute();
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.execute();
        }
        this.addElements.getElements().forEach(e -> {
            String string = this.newQualNames.put((INamedElement)e, e.getQualifiedName());
        });
    }

    public void redo() {
        super.redo();
        this.addElements.redo();
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.redo();
        }
    }

    public void undo() {
        if (this.mapSubappCmd != null) {
            this.mapSubappCmd.undo();
        }
        this.addElements.undo();
        super.undo();
    }

    private void checkMapping(List<?> selection) {
        Resource res = null;
        for (Object ne : selection) {
            EditPart editPart;
            Object object;
            if (!(ne instanceof EditPart) || !((object = (editPart = (EditPart)ne).getModel()) instanceof FBNetworkElement)) continue;
            FBNetworkElement element = (FBNetworkElement)object;
            if (!element.isMapped()) {
                return;
            }
            if (res == null) {
                res = element.getResource();
                continue;
            }
            if (res == element.getResource()) continue;
            return;
        }
        if (res != null) {
            this.mapSubappCmd = MapToCommand.createMapToCommand((FBNetworkElement)this.getElement(), res);
        }
    }

    protected final InterfaceList createInterfaceList() {
        return LibraryElementFactory.eINSTANCE.createInterfaceList();
    }

    protected String getInitialInstanceName() {
        return "SubApp";
    }

    public UntypedSubApp getElement() {
        return (UntypedSubApp)super.getElement();
    }

    public String getOldQualName(INamedElement elemt) {
        return this.oldQualNames.get(elemt);
    }

    public String getNewQualName(INamedElement element) {
        return this.newQualNames.get(element);
    }

    public List<INamedElement> getChangedElements() {
        return new ArrayList<FBNetworkElement>(this.addElements.getElements());
    }
}

