/*****************************************************************************
 * Copyright (c) 2014-2026 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#pragma once

#include "GameAction.h"

namespace OpenRCT2::GameActions
{
    class ParkSetResearchFundingAction final : public GameActionBase<GameCommand::SetResearchFunding>
    {
    private:
        // TODO change to std::optional when C++17
        uint32_t _priorities{};
        uint8_t _fundingAmount{};

    public:
        ParkSetResearchFundingAction() = default;
        ParkSetResearchFundingAction(uint32_t priorities, uint8_t fundingAmount);

        void AcceptParameters(GameActionParameterVisitor&) final;

        uint16_t GetActionFlags() const override;

        void Serialise(DataSerialiser& stream) override;
        Result Query(GameState_t& gameState) const override;
        Result Execute(GameState_t& gameState) const override;
    };
} // namespace OpenRCT2::GameActions
