// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See sync_validation_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2026 Valve Corporation
 * Copyright (c) 2015-2026 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#pragma once

#include <array>
#include <map>
#include <stdint.h>
#include <vulkan/vulkan.h>
#include "containers/custom_containers.h"
#include "sync/sync_access_flags.h"
// clang-format off
static constexpr VkAccessFlags2 kShaderReadExpandBits = VK_ACCESS_2_SHADER_SAMPLED_READ_BIT|VK_ACCESS_2_SHADER_STORAGE_READ_BIT|VK_ACCESS_2_SHADER_TILE_ATTACHMENT_READ_BIT_QCOM|VK_ACCESS_2_SHADER_BINDING_TABLE_READ_BIT_KHR;
static constexpr VkAccessFlags2 kShaderWriteExpandBits = VK_ACCESS_2_SHADER_STORAGE_WRITE_BIT|VK_ACCESS_2_SHADER_TILE_ATTACHMENT_WRITE_BIT_QCOM;
static constexpr VkPipelineStageFlags2 kAllTransferExpandBits = VK_PIPELINE_STAGE_2_COPY_BIT|VK_PIPELINE_STAGE_2_RESOLVE_BIT|VK_PIPELINE_STAGE_2_BLIT_BIT|VK_PIPELINE_STAGE_2_CLEAR_BIT|VK_PIPELINE_STAGE_2_ACCELERATION_STRUCTURE_COPY_BIT_KHR;

// Fake stages and accesses for acquire present support
static const VkPipelineStageFlagBits2 VK_PIPELINE_STAGE_2_PRESENT_ENGINE_BIT_SYNCVAL = 0x0000800000000000ULL;
static const VkAccessFlagBits2 VK_ACCESS_2_PRESENT_ACQUIRE_READ_BIT_SYNCVAL = 0x0800000000000000ULL;
static const VkAccessFlagBits2 VK_ACCESS_2_PRESENT_PRESENTED_BIT_SYNCVAL = 0x1000000000000000ULL;
// Unique number for each  stage/access combination
enum SyncAccessIndex {
    SYNC_ACCESS_INDEX_NONE = 0,
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ = 1,
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 2,
    SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ = 3,
    SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 4,
    SYNC_VERTEX_SHADER_RESOURCE_HEAP_READ_EXT = 5,
    SYNC_VERTEX_SHADER_SAMPLER_HEAP_READ_EXT = 6,
    SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ = 7,
    SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ = 8,
    SYNC_VERTEX_SHADER_SHADER_STORAGE_READ = 9,
    SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE = 10,
    SYNC_VERTEX_SHADER_UNIFORM_READ = 11,
    SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ = 12,
    SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 13,
    SYNC_TESSELLATION_CONTROL_SHADER_RESOURCE_HEAP_READ_EXT = 14,
    SYNC_TESSELLATION_CONTROL_SHADER_SAMPLER_HEAP_READ_EXT = 15,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ = 16,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ = 17,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ = 18,
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE = 19,
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ = 20,
    SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ = 21,
    SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 22,
    SYNC_TESSELLATION_EVALUATION_SHADER_RESOURCE_HEAP_READ_EXT = 23,
    SYNC_TESSELLATION_EVALUATION_SHADER_SAMPLER_HEAP_READ_EXT = 24,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ = 25,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ = 26,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ = 27,
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE = 28,
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ = 29,
    SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ = 30,
    SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 31,
    SYNC_GEOMETRY_SHADER_RESOURCE_HEAP_READ_EXT = 32,
    SYNC_GEOMETRY_SHADER_SAMPLER_HEAP_READ_EXT = 33,
    SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ = 34,
    SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ = 35,
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ = 36,
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE = 37,
    SYNC_GEOMETRY_SHADER_UNIFORM_READ = 38,
    SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ = 39,
    SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ = 40,
    SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ = 41,
    SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 42,
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ = 43,
    SYNC_FRAGMENT_SHADER_RESOURCE_HEAP_READ_EXT = 44,
    SYNC_FRAGMENT_SHADER_SAMPLER_HEAP_READ_EXT = 45,
    SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ = 46,
    SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ = 47,
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ = 48,
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE = 49,
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM = 50,
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM = 51,
    SYNC_FRAGMENT_SHADER_UNIFORM_READ = 52,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 53,
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 54,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ = 55,
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE = 56,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ = 57,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT = 58,
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE = 59,
    SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ = 60,
    SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 61,
    SYNC_COMPUTE_SHADER_RESOURCE_HEAP_READ_EXT = 62,
    SYNC_COMPUTE_SHADER_SAMPLER_HEAP_READ_EXT = 63,
    SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ = 64,
    SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ = 65,
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ = 66,
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE = 67,
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM = 68,
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM = 69,
    SYNC_COMPUTE_SHADER_UNIFORM_READ = 70,
    SYNC_HOST_HOST_READ = 71,
    SYNC_HOST_HOST_WRITE = 72,
    SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_READ_EXT = 73,
    SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_WRITE_EXT = 74,
    SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT = 75,
    SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ = 76,
    SYNC_TASK_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT = 77,
    SYNC_TASK_SHADER_EXT_RESOURCE_HEAP_READ_EXT = 78,
    SYNC_TASK_SHADER_EXT_SAMPLER_HEAP_READ_EXT = 79,
    SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ = 80,
    SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ = 81,
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ = 82,
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE = 83,
    SYNC_TASK_SHADER_EXT_UNIFORM_READ = 84,
    SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ = 85,
    SYNC_MESH_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT = 86,
    SYNC_MESH_SHADER_EXT_RESOURCE_HEAP_READ_EXT = 87,
    SYNC_MESH_SHADER_EXT_SAMPLER_HEAP_READ_EXT = 88,
    SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ = 89,
    SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ = 90,
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ = 91,
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE = 92,
    SYNC_MESH_SHADER_EXT_UNIFORM_READ = 93,
    SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ = 94,
    SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_EXT = 95,
    SYNC_RAY_TRACING_SHADER_RESOURCE_HEAP_READ_EXT = 96,
    SYNC_RAY_TRACING_SHADER_SAMPLER_HEAP_READ_EXT = 97,
    SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ = 98,
    SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ = 99,
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ = 100,
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE = 101,
    SYNC_RAY_TRACING_SHADER_UNIFORM_READ = 102,
    SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ = 103,
    SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT = 104,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT = 105,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT = 106,
    SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT = 107,
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ = 108,
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE = 109,
    SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ = 110,
    SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_EXT = 111,
    SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ = 112,
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ = 113,
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE = 114,
    SYNC_VIDEO_DECODE_VIDEO_DECODE_READ = 115,
    SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE = 116,
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ = 117,
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE = 118,
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ = 119,
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE = 120,
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ = 121,
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE = 122,
    SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_READ_NV = 123,
    SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_WRITE_NV = 124,
    SYNC_MICROMAP_BUILD_EXT_MICROMAP_READ_EXT = 125,
    SYNC_MICROMAP_BUILD_EXT_MICROMAP_WRITE_EXT = 126,
    SYNC_MICROMAP_BUILD_EXT_SHADER_READ = 127,
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ = 128,
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE = 129,
    SYNC_COPY_TRANSFER_READ = 130,
    SYNC_COPY_TRANSFER_WRITE = 131,
    SYNC_RESOLVE_TRANSFER_READ = 132,
    SYNC_RESOLVE_TRANSFER_WRITE = 133,
    SYNC_BLIT_TRANSFER_READ = 134,
    SYNC_BLIT_TRANSFER_WRITE = 135,
    SYNC_CLEAR_TRANSFER_WRITE = 136,
    SYNC_INDEX_INPUT_INDEX_READ = 137,
    SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ = 138,
    SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ = 139,
    SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT = 140,
    SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ = 141,
    SYNC_SUBPASS_SHADER_HUAWEI_RESOURCE_HEAP_READ_EXT = 142,
    SYNC_SUBPASS_SHADER_HUAWEI_SAMPLER_HEAP_READ_EXT = 143,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ = 144,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ = 145,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ = 146,
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE = 147,
    SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ = 148,
    SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI = 149,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ = 150,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT = 151,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_RESOURCE_HEAP_READ_EXT = 152,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SAMPLER_HEAP_READ_EXT = 153,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ = 154,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ = 155,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ = 156,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE = 157,
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ = 158,
    SYNC_DATA_GRAPH_ARM_DATA_GRAPH_READ_ARM = 159,
    SYNC_DATA_GRAPH_ARM_DATA_GRAPH_WRITE_ARM = 160,
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ = 161,
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE = 162,
    SYNC_MEMORY_DECOMPRESSION_EXT_MEMORY_DECOMPRESSION_READ_EXT = 163,
    SYNC_MEMORY_DECOMPRESSION_EXT_MEMORY_DECOMPRESSION_WRITE_EXT = 164,
    SYNC_COPY_INDIRECT_INDIRECT_COMMAND_READ = 165,
    SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_ACQUIRE_READ_SYNCVAL = 166,
    SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_PRESENTED_SYNCVAL = 167,
    SYNC_IMAGE_LAYOUT_TRANSITION = 168,
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER = 169,
};

using syncval::SyncAccessFlags;
// Unique bit for each stage/access combination
static const SyncAccessFlags SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT = (SyncAccessFlags(1) << SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ);
static const SyncAccessFlags SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_VERTEX_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_GEOMETRY_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM);
static const SyncAccessFlags SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_EXT);
static const SyncAccessFlags SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM);
static const SyncAccessFlags SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_COMPUTE_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_HOST_HOST_READ_BIT = (SyncAccessFlags(1) << SYNC_HOST_HOST_READ);
static const SyncAccessFlags SYNC_HOST_HOST_WRITE_BIT = (SyncAccessFlags(1) << SYNC_HOST_HOST_WRITE);
static const SyncAccessFlags SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_READ_EXT);
static const SyncAccessFlags SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_COMMAND_PREPROCESS_EXT_COMMAND_PREPROCESS_WRITE_EXT);
static const SyncAccessFlags SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CONDITIONAL_RENDERING_EXT_CONDITIONAL_RENDERING_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_BIT_EXT_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_BIT_EXT_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_TASK_SHADER_EXT_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_TASK_SHADER_EXT_UNIFORM_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_MESH_SHADER_BIT_EXT_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_MESH_SHADER_BIT_EXT_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_MESH_SHADER_EXT_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_MESH_SHADER_EXT_UNIFORM_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_RAY_TRACING_SHADER_UNIFORM_READ);
static const SyncAccessFlags SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_FRAGMENT_DENSITY_PROCESS_EXT_FRAGMENT_DENSITY_MAP_READ_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_EXT);
static const SyncAccessFlags SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_TRANSFORM_FEEDBACK_EXT_TRANSFORM_FEEDBACK_WRITE_EXT);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_EXT);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_DECODE_VIDEO_DECODE_READ);
static const SyncAccessFlags SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE);
static const SyncAccessFlags SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ);
static const SyncAccessFlags SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ);
static const SyncAccessFlags SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_READ_BIT_NV = (SyncAccessFlags(1) << SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_READ_NV);
static const SyncAccessFlags SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_WRITE_BIT_NV = (SyncAccessFlags(1) << SYNC_OPTICAL_FLOW_NV_OPTICAL_FLOW_WRITE_NV);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_MICROMAP_READ_EXT);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_MICROMAP_WRITE_EXT);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_SHADER_READ_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_SHADER_READ);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ);
static const SyncAccessFlags SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_COPY_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_COPY_TRANSFER_READ);
static const SyncAccessFlags SYNC_COPY_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_COPY_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_RESOLVE_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_RESOLVE_TRANSFER_READ);
static const SyncAccessFlags SYNC_RESOLVE_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_RESOLVE_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_BLIT_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_BLIT_TRANSFER_READ);
static const SyncAccessFlags SYNC_BLIT_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_BLIT_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_CLEAR_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CLEAR_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_INDEX_INPUT_INDEX_READ_BIT = (SyncAccessFlags(1) << SYNC_INDEX_INPUT_INDEX_READ);
static const SyncAccessFlags SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT = (SyncAccessFlags(1) << SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ);
static const SyncAccessFlags SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI_BIT = (SyncAccessFlags(1) << SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_EXT);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_RESOURCE_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_RESOURCE_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SAMPLER_HEAP_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SAMPLER_HEAP_READ_EXT);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE);
static const SyncAccessFlags SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ_BIT = (SyncAccessFlags(1) << SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ);
static const SyncAccessFlags SYNC_DATA_GRAPH_ARM_DATA_GRAPH_READ_ARM_BIT = (SyncAccessFlags(1) << SYNC_DATA_GRAPH_ARM_DATA_GRAPH_READ_ARM);
static const SyncAccessFlags SYNC_DATA_GRAPH_ARM_DATA_GRAPH_WRITE_ARM_BIT = (SyncAccessFlags(1) << SYNC_DATA_GRAPH_ARM_DATA_GRAPH_WRITE_ARM);
static const SyncAccessFlags SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ_BIT = (SyncAccessFlags(1) << SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ);
static const SyncAccessFlags SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE_BIT = (SyncAccessFlags(1) << SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE);
static const SyncAccessFlags SYNC_MEMORY_DECOMPRESSION_BIT_EXT_MEMORY_DECOMPRESSION_READ_BIT_EXT = (SyncAccessFlags(1) << SYNC_MEMORY_DECOMPRESSION_EXT_MEMORY_DECOMPRESSION_READ_EXT);
static const SyncAccessFlags SYNC_MEMORY_DECOMPRESSION_BIT_EXT_MEMORY_DECOMPRESSION_WRITE_BIT_EXT = (SyncAccessFlags(1) << SYNC_MEMORY_DECOMPRESSION_EXT_MEMORY_DECOMPRESSION_WRITE_EXT);
static const SyncAccessFlags SYNC_COPY_INDIRECT_INDIRECT_COMMAND_READ_BIT = (SyncAccessFlags(1) << SYNC_COPY_INDIRECT_INDIRECT_COMMAND_READ);
static const SyncAccessFlags SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_ACQUIRE_READ_BIT_SYNCVAL = (SyncAccessFlags(1) << SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_ACQUIRE_READ_SYNCVAL);
static const SyncAccessFlags SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_PRESENTED_BIT_SYNCVAL = (SyncAccessFlags(1) << SYNC_PRESENT_ENGINE_SYNCVAL_PRESENT_PRESENTED_SYNCVAL);
static const SyncAccessFlags SYNC_IMAGE_LAYOUT_TRANSITION_BIT = (SyncAccessFlags(1) << SYNC_IMAGE_LAYOUT_TRANSITION);
static const SyncAccessFlags SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT = (SyncAccessFlags(1) << SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER);

struct SyncAccessInfo {
    const char *name;
    VkPipelineStageFlagBits2 stage_mask;
    VkAccessFlagBits2 access_mask;
    SyncAccessIndex access_index;
    SyncAccessFlags access_bit;
};

// Array of text names and component masks for each stage/access index
const std::array<SyncAccessInfo, 170>& GetSyncAccessInfos();

// Constants defining the mask of all read and write access states
static const SyncAccessFlags syncAccessReadMask = ( //  Mask of all read accesses
    SYNC_DRAW_INDIRECT_INDIRECT_COMMAND_READ_BIT |
    SYNC_DRAW_INDIRECT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_VERTEX_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_VERTEX_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_VERTEX_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_VERTEX_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_VERTEX_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TESSELLATION_CONTROL_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_TESSELLATION_CONTROL_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_UNIFORM_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TESSELLATION_EVALUATION_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_UNIFORM_READ_BIT |
    SYNC_GEOMETRY_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_GEOMETRY_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_GEOMETRY_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_GEOMETRY_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_GEOMETRY_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_GEOMETRY_SHADER_UNIFORM_READ_BIT |
    SYNC_FRAGMENT_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_FRAGMENT_SHADER_COLOR_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_FRAGMENT_SHADER_INPUT_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_FRAGMENT_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_FRAGMENT_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT |
    SYNC_FRAGMENT_SHADER_UNIFORM_READ_BIT |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_READ_NONCOHERENT_BIT_EXT |
    SYNC_COMPUTE_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_COMPUTE_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_COMPUTE_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_COMPUTE_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_COMPUTE_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_READ_QCOM_BIT |
    SYNC_COMPUTE_SHADER_UNIFORM_READ_BIT |
    SYNC_HOST_HOST_READ_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_READ_BIT_EXT |
    SYNC_CONDITIONAL_RENDERING_BIT_EXT_CONDITIONAL_RENDERING_READ_BIT_EXT |
    SYNC_TASK_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_TASK_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_TASK_SHADER_BIT_EXT_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_TASK_SHADER_BIT_EXT_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_TASK_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_TASK_SHADER_EXT_SHADER_SAMPLED_READ_BIT |
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_READ_BIT |
    SYNC_TASK_SHADER_EXT_UNIFORM_READ_BIT |
    SYNC_MESH_SHADER_EXT_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_MESH_SHADER_BIT_EXT_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_MESH_SHADER_BIT_EXT_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_MESH_SHADER_BIT_EXT_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_MESH_SHADER_EXT_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_SAMPLED_READ_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_READ_BIT |
    SYNC_MESH_SHADER_EXT_UNIFORM_READ_BIT |
    SYNC_RAY_TRACING_SHADER_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_RAY_TRACING_SHADER_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_RAY_TRACING_SHADER_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_RAY_TRACING_SHADER_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_SAMPLED_READ_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_READ_BIT |
    SYNC_RAY_TRACING_SHADER_UNIFORM_READ_BIT |
    SYNC_FRAGMENT_SHADING_RATE_ATTACHMENT_FRAGMENT_SHADING_RATE_ATTACHMENT_READ_BIT |
    SYNC_FRAGMENT_DENSITY_PROCESS_BIT_EXT_FRAGMENT_DENSITY_MAP_READ_BIT_EXT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_READ_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_INDIRECT_COMMAND_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_MICROMAP_READ_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_SHADER_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_READ_BIT |
    SYNC_VIDEO_DECODE_VIDEO_DECODE_READ_BIT |
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_READ_BIT |
    SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_READ_BIT_NV |
    SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_READ_BIT_EXT |
    SYNC_MICROMAP_BUILD_EXT_SHADER_READ_BIT |
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_READ_BIT |
    SYNC_COPY_TRANSFER_READ_BIT |
    SYNC_RESOLVE_TRANSFER_READ_BIT |
    SYNC_BLIT_TRANSFER_READ_BIT |
    SYNC_INDEX_INPUT_INDEX_READ_BIT |
    SYNC_VERTEX_ATTRIBUTE_INPUT_VERTEX_ATTRIBUTE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_SUBPASS_SHADER_HUAWEI_INPUT_ATTACHMENT_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_SUBPASS_SHADER_HUAWEI_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_UNIFORM_READ_BIT |
    SYNC_INVOCATION_MASK_HUAWEI_INVOCATION_MASK_READ_HUAWEI_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_ACCELERATION_STRUCTURE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_DESCRIPTOR_BUFFER_READ_BIT_EXT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_RESOURCE_HEAP_READ_BIT_EXT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SAMPLER_HEAP_READ_BIT_EXT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_BINDING_TABLE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_SAMPLED_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_READ_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_UNIFORM_READ_BIT |
    SYNC_DATA_GRAPH_ARM_DATA_GRAPH_READ_ARM_BIT |
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_READ_BIT |
    SYNC_MEMORY_DECOMPRESSION_BIT_EXT_MEMORY_DECOMPRESSION_READ_BIT_EXT |
    SYNC_COPY_INDIRECT_INDIRECT_COMMAND_READ_BIT |
    SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_ACQUIRE_READ_BIT_SYNCVAL
);

static const SyncAccessFlags syncAccessWriteMask = ( //  Mask of all write accesses
    SYNC_VERTEX_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TESSELLATION_CONTROL_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TESSELLATION_EVALUATION_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_GEOMETRY_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_FRAGMENT_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT |
    SYNC_EARLY_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_LATE_FRAGMENT_TESTS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT |
    SYNC_COLOR_ATTACHMENT_OUTPUT_COLOR_ATTACHMENT_WRITE_BIT |
    SYNC_COMPUTE_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_COMPUTE_SHADER_SHADER_TILE_ATTACHMENT_WRITE_QCOM_BIT |
    SYNC_HOST_HOST_WRITE_BIT |
    SYNC_COMMAND_PREPROCESS_BIT_EXT_COMMAND_PREPROCESS_WRITE_BIT_EXT |
    SYNC_TASK_SHADER_EXT_SHADER_STORAGE_WRITE_BIT |
    SYNC_MESH_SHADER_EXT_SHADER_STORAGE_WRITE_BIT |
    SYNC_RAY_TRACING_SHADER_SHADER_STORAGE_WRITE_BIT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_COUNTER_WRITE_BIT_EXT |
    SYNC_TRANSFORM_FEEDBACK_BIT_EXT_TRANSFORM_FEEDBACK_WRITE_BIT_EXT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_ACCELERATION_STRUCTURE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_BUILD_TRANSFER_WRITE_BIT |
    SYNC_VIDEO_DECODE_VIDEO_DECODE_WRITE_BIT |
    SYNC_VIDEO_ENCODE_VIDEO_ENCODE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_ACCELERATION_STRUCTURE_WRITE_BIT |
    SYNC_ACCELERATION_STRUCTURE_COPY_TRANSFER_WRITE_BIT |
    SYNC_OPTICAL_FLOW_BIT_NV_OPTICAL_FLOW_WRITE_BIT_NV |
    SYNC_MICROMAP_BUILD_BIT_EXT_MICROMAP_WRITE_BIT_EXT |
    SYNC_MICROMAP_BUILD_EXT_TRANSFER_WRITE_BIT |
    SYNC_COPY_TRANSFER_WRITE_BIT |
    SYNC_RESOLVE_TRANSFER_WRITE_BIT |
    SYNC_BLIT_TRANSFER_WRITE_BIT |
    SYNC_CLEAR_TRANSFER_WRITE_BIT |
    SYNC_SUBPASS_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT |
    SYNC_CLUSTER_CULLING_SHADER_HUAWEI_SHADER_STORAGE_WRITE_BIT |
    SYNC_DATA_GRAPH_ARM_DATA_GRAPH_WRITE_ARM_BIT |
    SYNC_CONVERT_COOPERATIVE_VECTOR_MATRIX_NV_TRANSFER_WRITE_BIT |
    SYNC_MEMORY_DECOMPRESSION_BIT_EXT_MEMORY_DECOMPRESSION_WRITE_BIT_EXT |
    SYNC_PRESENT_ENGINE_BIT_SYNCVAL_PRESENT_PRESENTED_BIT_SYNCVAL |
    SYNC_IMAGE_LAYOUT_TRANSITION_BIT |
    SYNC_QUEUE_FAMILY_OWNERSHIP_TRANSFER_BIT
);

// Bit order mask of accesses for each stage. Order matters, don't try to use vvl::unordered_map
const std::map<VkPipelineStageFlagBits2, SyncAccessFlags>& syncAccessMaskByStageBit();

// Bit order mask of accesses for each VkAccess. Order matters, don't try to use vvl::unordered_map
const std::map<VkAccessFlagBits2, SyncAccessFlags>& syncAccessMaskByAccessBit();

// Direct VkPipelineStageFlags to valid VkAccessFlags lookup table
const vvl::unordered_map<VkPipelineStageFlagBits2, VkAccessFlags2>& syncDirectStageToAccessMask();

// Pipeline stages corresponding to VK_PIPELINE_STAGE_2_ALL_COMMANDS_BIT for each VkQueueFlagBits
const vvl::unordered_map<VkQueueFlagBits, VkPipelineStageFlags2>& syncAllCommandStagesByQueueFlags();

// Masks of logically earlier stage flags for a given stage flag
const vvl::unordered_map<VkPipelineStageFlagBits2, VkPipelineStageFlags2>& syncLogicallyEarlierStages();

// Masks of logically later stage flags for a given stage flag
const vvl::unordered_map<VkPipelineStageFlagBits2, VkPipelineStageFlags2>& syncLogicallyLaterStages();
// clang-format on

// NOLINTEND
