/* serializer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include "calculator.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <langinfo.h>
#include <float.h>
#include <math.h>
#include "mpfr.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SERIALIZER_0_PROPERTY,
	SERIALIZER_ERROR_PROPERTY,
	SERIALIZER_CHECK_FIXED_MAX_PROPERTY,
	SERIALIZER_NUM_PROPERTIES
};
static GParamSpec* serializer_properties[SERIALIZER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
	gchar* zero_string;
	gchar* _error;
	gboolean _check_fixed_max;
};

static gint Serializer_private_offset;
static gpointer serializer_parent_class = NULL;
static Number* serializer__fixed_max;
static Number* serializer__fixed_max = NULL;

static void serializer_update_zero_string (Serializer* self);
static gchar* serializer_cast_to_string (Serializer* self,
                                  Number* x,
                                  gint* n_digits);
static gchar* serializer_to_automatic_string (Serializer* self,
                                       Number* x,
                                       gboolean eng_format);
static gchar* serializer_cast_to_exponential_string (Serializer* self,
                                              Number* x,
                                              gboolean eng_format);
static gboolean serializer_cast_to_string_real (Serializer* self,
                                         Number* x,
                                         GString* string,
                                         gboolean force_sign,
                                         gint* n_digits);
static gint serializer_cast_to_exponential_string_real (Serializer* self,
                                                 Number* x,
                                                 GString* string,
                                                 gboolean eng_format,
                                                 gboolean force_sign);
static void serializer_append_exponent (Serializer* self,
                                 GString* string,
                                 gint exponent);
static void serializer_finalize (GObject * obj);
static GType serializer_get_type_once (void);
static void _vala_serializer_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_serializer_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

 G_GNUC_NO_INLINE static GType
display_format_get_type_once (void)
{
	static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
	GType display_format_type_id;
	display_format_type_id = g_enum_register_static ("DisplayFormat", values);
	return display_format_type_id;
}

GType
display_format_get_type (void)
{
	static gsize display_format_type_id__once = 0;
	if (g_once_init_enter (&display_format_type_id__once)) {
		GType display_format_type_id;
		display_format_type_id = display_format_get_type_once ();
		g_once_init_leave (&display_format_type_id__once, display_format_type_id);
	}
	return display_format_type_id__once;
}

static inline gpointer
serializer_get_instance_private (Serializer* self)
{
	return G_STRUCT_MEMBER_P (self, Serializer_private_offset);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

Serializer*
serializer_construct (GType object_type,
                      DisplayFormat format,
                      gint number_base,
                      gint trailing_digits)
{
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	self = (Serializer*) g_object_new (object_type, NULL);
	_tmp0_ = nl_langinfo (RADIXCHAR);
	_tmp1_ = g_strdup (_tmp0_);
	radix_string = _tmp1_;
	_tmp3_ = radix_string;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = radix_string;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* radix_utf8 = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = radix_string;
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) -1, NULL, NULL, NULL);
		radix_utf8 = _tmp6_;
		_tmp7_ = radix_utf8;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			_tmp8_ = radix_utf8;
			self->priv->radix = string_get_char (_tmp8_, (glong) 0);
		} else {
			self->priv->radix = (gunichar) '.';
		}
		_g_free0 (radix_utf8);
	} else {
		self->priv->radix = (gunichar) '.';
	}
	_tmp9_ = nl_langinfo (THOUSEP);
	_tmp10_ = g_strdup (_tmp9_);
	tsep_string = _tmp10_;
	_tmp12_ = tsep_string;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		_tmp13_ = tsep_string;
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* tsep_utf8 = NULL;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp14_ = tsep_string;
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) -1, NULL, NULL, NULL);
		tsep_utf8 = _tmp15_;
		_tmp16_ = tsep_utf8;
		if (_tmp16_ != NULL) {
			const gchar* _tmp17_;
			_tmp17_ = tsep_utf8;
			self->priv->tsep = string_get_char (_tmp17_, (glong) 0);
		} else {
			self->priv->tsep = (gunichar) ' ';
		}
		_g_free0 (tsep_utf8);
	} else {
		self->priv->tsep = (gunichar) ' ';
	}
	self->priv->tsep_count = 3;
	self->priv->number_base = number_base;
	self->priv->representation_base = (guint) number_base;
	self->priv->leading_digits = 12;
	self->priv->trailing_digits = trailing_digits;
	self->priv->show_zeroes = FALSE;
	self->priv->show_tsep = FALSE;
	self->priv->format = format;
	serializer_update_zero_string (self);
	_g_free0 (tsep_string);
	_g_free0 (radix_string);
	return self;
}

Serializer*
serializer_new (DisplayFormat format,
                gint number_base,
                gint trailing_digits)
{
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
}

gchar*
serializer_to_string (Serializer* self,
                      Number* x)
{
	gint n_digits = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	serializer_set_error (self, NULL);
	if (!number_is_finite (x)) {
		gint is_infinity = 0;
		gchar* _tmp2_;
		is_infinity = isinf (number_to_double (x));
		if (is_infinity > 0) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("∞");
			result = _tmp0_;
			return result;
		}
		if (is_infinity < 0) {
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("−∞");
			result = _tmp1_;
			return result;
		}
		_tmp2_ = g_strdup ("NaN");
		result = _tmp2_;
		return result;
	}
	n_digits = 0;
	if (self->priv->representation_base != ((guint) self->priv->number_base)) {
		gchar* _tmp3_;
		_tmp3_ = serializer_cast_to_string (self, x, &n_digits);
		result = _tmp3_;
		return result;
	}
	switch (self->priv->format) {
		default:
		case DISPLAY_FORMAT_AUTOMATIC:
		{
			gchar* _tmp4_;
			_tmp4_ = serializer_to_automatic_string (self, x, FALSE);
			result = _tmp4_;
			return result;
		}
		case DISPLAY_FORMAT_FIXED:
		{
			gchar* _tmp5_;
			_tmp5_ = serializer_cast_to_string (self, x, &n_digits);
			result = _tmp5_;
			return result;
		}
		case DISPLAY_FORMAT_SCIENTIFIC:
		{
			if (self->priv->representation_base == ((guint) 10)) {
				gchar* _tmp6_;
				_tmp6_ = serializer_cast_to_exponential_string (self, x, FALSE);
				result = _tmp6_;
				return result;
			} else {
				gchar* _tmp7_;
				_tmp7_ = serializer_to_automatic_string (self, x, FALSE);
				result = _tmp7_;
				return result;
			}
		}
		case DISPLAY_FORMAT_ENGINEERING:
		{
			if (self->priv->representation_base == ((guint) 10)) {
				gchar* _tmp8_;
				_tmp8_ = serializer_cast_to_exponential_string (self, x, TRUE);
				result = _tmp8_;
				return result;
			} else {
				gchar* _tmp9_;
				_tmp9_ = serializer_to_automatic_string (self, x, TRUE);
				result = _tmp9_;
				return result;
			}
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
serializer_to_dms_string (Serializer* self,
                          Number* number)
{
	Number* eps = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	mpfr_prec_t _tmp2_;
	mpfr_prec_t _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* rounded_number = NULL;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	gboolean _tmp17_;
	Number* minute = NULL;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* _tmp22_;
	Number* rounded_minute = NULL;
	Number* _tmp23_;
	Number* _tmp24_;
	Number* _tmp25_;
	Number* _tmp26_;
	Number* _tmp27_;
	Number* _tmp28_;
	Number* _tmp29_;
	Number* _tmp30_;
	Number* _tmp31_;
	gboolean _tmp32_;
	gchar* d = NULL;
	Number* _tmp35_;
	Number* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* m = NULL;
	Number* _tmp39_;
	Number* _tmp40_;
	Number* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* s = NULL;
	Number* _tmp44_;
	Number* _tmp45_;
	Number* _tmp46_;
	Number* _tmp47_;
	Number* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp72_;
	const gchar* _tmp73_;
	const gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (number != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_get_precision ();
	_tmp3_ = _tmp2_;
	_tmp4_ = number_xpowy_integer (_tmp1_, (gint64) (8 - _tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = number_multiply (number, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_abs (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	eps = _tmp9_;
	_tmp10_ = number_round (number);
	rounded_number = _tmp10_;
	_tmp11_ = rounded_number;
	_tmp12_ = number_subtract (number, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = number_abs (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = eps;
	_tmp17_ = number_compare (_tmp15_, _tmp16_) < 0;
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp13_);
	if (_tmp17_) {
		Number* _tmp18_;
		_tmp18_ = rounded_number;
		number = _tmp18_;
	}
	_tmp19_ = number_fractional_component (number);
	_tmp20_ = _tmp19_;
	_tmp21_ = number_multiply_integer (_tmp20_, (gint64) 60);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp20_);
	minute = _tmp22_;
	_tmp23_ = minute;
	_tmp24_ = number_round (_tmp23_);
	rounded_minute = _tmp24_;
	_tmp25_ = minute;
	_tmp26_ = rounded_minute;
	_tmp27_ = number_subtract (_tmp25_, _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = number_abs (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = eps;
	_tmp32_ = number_compare (_tmp30_, _tmp31_) < 0;
	_g_object_unref0 (_tmp30_);
	_g_object_unref0 (_tmp28_);
	if (_tmp32_) {
		Number* _tmp33_;
		Number* _tmp34_;
		_tmp33_ = rounded_minute;
		_tmp34_ = _g_object_ref0 (_tmp33_);
		_g_object_unref0 (minute);
		minute = _tmp34_;
	}
	_tmp35_ = number_integer_component (number);
	_tmp36_ = _tmp35_;
	_tmp37_ = serializer_to_string (self, _tmp36_);
	_tmp38_ = _tmp37_;
	_g_object_unref0 (_tmp36_);
	d = _tmp38_;
	_tmp39_ = minute;
	_tmp40_ = number_integer_component (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = serializer_to_string (self, _tmp41_);
	_tmp43_ = _tmp42_;
	_g_object_unref0 (_tmp41_);
	m = _tmp43_;
	_tmp44_ = minute;
	_tmp45_ = number_fractional_component (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = number_multiply_integer (_tmp46_, (gint64) 60);
	_tmp48_ = _tmp47_;
	_tmp49_ = serializer_to_string (self, _tmp48_);
	_tmp50_ = _tmp49_;
	_g_object_unref0 (_tmp48_);
	_g_object_unref0 (_tmp46_);
	s = _tmp50_;
	_tmp51_ = s;
	if (g_str_has_prefix (_tmp51_, "60")) {
		const gchar* _tmp52_;
		gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp52_ = self->priv->zero_string;
		_tmp53_ = g_strdup (_tmp52_);
		_g_free0 (s);
		s = _tmp53_;
		_tmp54_ = m;
		if (g_str_has_prefix (_tmp54_, "59")) {
			const gchar* _tmp55_;
			gchar* _tmp56_;
			Number* _tmp57_;
			Number* _tmp58_;
			Number* _tmp59_;
			Number* _tmp60_;
			Number* _tmp61_;
			Number* _tmp62_;
			gchar* _tmp63_;
			_tmp55_ = self->priv->zero_string;
			_tmp56_ = g_strdup (_tmp55_);
			_g_free0 (m);
			m = _tmp56_;
			_tmp57_ = number_integer_component (number);
			_tmp58_ = _tmp57_;
			_tmp59_ = number_new_integer ((gint64) 1, (gint64) 0);
			_tmp60_ = _tmp59_;
			_tmp61_ = number_add (_tmp58_, _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = serializer_to_string (self, _tmp62_);
			_g_free0 (d);
			d = _tmp63_;
			_g_object_unref0 (_tmp62_);
			_g_object_unref0 (_tmp60_);
			_g_object_unref0 (_tmp58_);
		} else {
			Number* _tmp64_;
			Number* _tmp65_;
			Number* _tmp66_;
			Number* _tmp67_;
			Number* _tmp68_;
			Number* _tmp69_;
			Number* _tmp70_;
			gchar* _tmp71_;
			_tmp64_ = minute;
			_tmp65_ = number_integer_component (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = number_new_integer ((gint64) 1, (gint64) 0);
			_tmp68_ = _tmp67_;
			_tmp69_ = number_add (_tmp66_, _tmp68_);
			_tmp70_ = _tmp69_;
			_tmp71_ = serializer_to_string (self, _tmp70_);
			_g_free0 (m);
			m = _tmp71_;
			_g_object_unref0 (_tmp70_);
			_g_object_unref0 (_tmp68_);
			_g_object_unref0 (_tmp66_);
		}
	}
	_tmp72_ = d;
	_tmp73_ = m;
	_tmp74_ = s;
	_tmp75_ = g_strdup_printf ("%s°%s′%s″", _tmp72_, _tmp73_, _tmp74_);
	result = _tmp75_;
	_g_free0 (s);
	_g_free0 (m);
	_g_free0 (d);
	_g_object_unref0 (rounded_minute);
	_g_object_unref0 (minute);
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (eps);
	return result;
}

Number*
serializer_from_string (Serializer* self,
                        const gchar* str)
{
	Number* _tmp0_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = mp_set_from_string (str, self->priv->number_base, TRUE);
	result = _tmp0_;
	return result;
}

gint
serializer_get_base (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->number_base;
	return result;
}

void
serializer_set_base (Serializer* self,
                     gint number_base)
{
	g_return_if_fail (self != NULL);
	self->priv->number_base = number_base;
}

guint
serializer_get_representation_base (Serializer* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->representation_base;
	return result;
}

void
serializer_set_representation_base (Serializer* self,
                                    guint representation_base)
{
	g_return_if_fail (self != NULL);
	self->priv->representation_base = representation_base;
}

gunichar
serializer_get_radix (Serializer* self)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->radix;
	return result;
}

void
serializer_set_radix (Serializer* self,
                      gunichar radix)
{
	g_return_if_fail (self != NULL);
	self->priv->radix = radix;
	serializer_update_zero_string (self);
}

gunichar
serializer_get_thousands_separator (Serializer* self)
{
	gunichar _tmp0_ = 0U;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	if (self->priv->representation_base == ((guint) 10)) {
		_tmp0_ = self->priv->tsep;
	} else {
		_tmp0_ = 8239U;
	}
	result = _tmp0_;
	return result;
}

void
serializer_set_thousands_separator (Serializer* self,
                                    gunichar separator)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep = separator;
}

gboolean
serializer_is_thousands_separator (Serializer* self,
                                   gunichar c)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (c == self->priv->tsep) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == 8239U;
	}
	result = _tmp0_;
	return result;
}

gint
serializer_get_thousands_separator_count (Serializer* self)
{
	gint _tmp0_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->priv->representation_base == ((guint) 10)) {
		_tmp0_ = self->priv->tsep_count;
	} else {
		_tmp0_ = 4;
	}
	result = _tmp0_;
	return result;
}

void
serializer_set_thousands_separator_count (Serializer* self,
                                          gint count)
{
	g_return_if_fail (self != NULL);
	self->priv->tsep_count = count;
}

gboolean
serializer_get_show_thousands_separators (Serializer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->show_tsep;
	return result;
}

void
serializer_set_show_thousands_separators (Serializer* self,
                                          gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_tsep = visible;
}

gboolean
serializer_get_show_trailing_zeroes (Serializer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->show_zeroes;
	return result;
}

void
serializer_set_show_trailing_zeroes (Serializer* self,
                                     gboolean visible)
{
	g_return_if_fail (self != NULL);
	self->priv->show_zeroes = visible;
	serializer_update_zero_string (self);
}

gint
serializer_get_leading_digits (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->leading_digits;
	return result;
}

void
serializer_set_leading_digits (Serializer* self,
                               gint leading_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->leading_digits = leading_digits;
}

gint
serializer_get_trailing_digits (Serializer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->trailing_digits;
	return result;
}

void
serializer_set_trailing_digits (Serializer* self,
                                gint trailing_digits)
{
	g_return_if_fail (self != NULL);
	self->priv->trailing_digits = trailing_digits;
	serializer_update_zero_string (self);
}

DisplayFormat
serializer_get_number_format (Serializer* self)
{
	DisplayFormat result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->format;
	return result;
}

void
serializer_set_number_format (Serializer* self,
                              DisplayFormat format)
{
	g_return_if_fail (self != NULL);
	self->priv->format = format;
}

static void
serializer_update_zero_string (Serializer* self)
{
	gint n_digits = 0;
	Number* _tmp0_;
	Number* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	n_digits = 0;
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = serializer_cast_to_string (self, _tmp1_, &n_digits);
	_g_free0 (self->priv->zero_string);
	self->priv->zero_string = _tmp2_;
	_g_object_unref0 (_tmp1_);
}

static gchar*
serializer_to_automatic_string (Serializer* self,
                                Number* x,
                                gboolean eng_format)
{
	gint n_digits = 0;
	gchar* s0 = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	n_digits = 0;
	_tmp0_ = serializer_cast_to_string (self, x, &n_digits);
	s0 = _tmp0_;
	serializer_set_error (self, NULL);
	switch (self->priv->representation_base) {
		case 2:
		{
			gboolean _tmp1_ = FALSE;
			if (n_digits <= 64) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = s0;
				_tmp3_ = self->priv->zero_string;
				_tmp1_ = g_strcmp0 (_tmp2_, _tmp3_) != 0;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				result = s0;
				return result;
			} else {
				gchar* _tmp4_;
				_tmp4_ = serializer_cast_to_exponential_string (self, x, eng_format);
				result = _tmp4_;
				_g_free0 (s0);
				return result;
			}
		}
		case 8:
		{
			gboolean _tmp5_ = FALSE;
			if (n_digits <= 22) {
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = s0;
				_tmp7_ = self->priv->zero_string;
				_tmp5_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				result = s0;
				return result;
			} else {
				gchar* _tmp8_;
				_tmp8_ = serializer_cast_to_exponential_string (self, x, eng_format);
				result = _tmp8_;
				_g_free0 (s0);
				return result;
			}
		}
		case 16:
		{
			gboolean _tmp9_ = FALSE;
			if (n_digits <= 16) {
				const gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = s0;
				_tmp11_ = self->priv->zero_string;
				_tmp9_ = g_strcmp0 (_tmp10_, _tmp11_) != 0;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				result = s0;
				return result;
			} else {
				gchar* _tmp12_;
				_tmp12_ = serializer_cast_to_exponential_string (self, x, eng_format);
				result = _tmp12_;
				_g_free0 (s0);
				return result;
			}
		}
		default:
		case 10:
		{
			gboolean _tmp13_ = FALSE;
			if (n_digits <= self->priv->leading_digits) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp14_ = s0;
				_tmp15_ = self->priv->zero_string;
				_tmp13_ = g_strcmp0 (_tmp14_, _tmp15_) != 0;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				result = s0;
				return result;
			} else {
				gchar* _tmp16_;
				_tmp16_ = serializer_cast_to_exponential_string (self, x, eng_format);
				result = _tmp16_;
				_g_free0 (s0);
				return result;
			}
		}
	}
}

static gchar*
serializer_cast_to_string (Serializer* self,
                           Number* x,
                           gint* n_digits)
{
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	GString* _tmp3_;
	gboolean _tmp4_;
	GString* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = string;
	_tmp4_ = serializer_cast_to_string_real (self, _tmp2_, _tmp3_, FALSE, n_digits);
	if (!_tmp4_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->priv->zero_string;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_object_unref0 (x_real);
		_g_string_free0 (string);
		return result;
	}
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp7_;
		gboolean force_sign = FALSE;
		GString* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GString* s = NULL;
		GString* _tmp12_;
		gint n_complex_digits = 0;
		Number* _tmp13_;
		GString* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		GString* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp7_ = number_imaginary_component (x);
		x_im = _tmp7_;
		force_sign = TRUE;
		_tmp8_ = string;
		_tmp9_ = _tmp8_->str;
		_tmp10_ = self->priv->zero_string;
		if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
			GString* _tmp11_;
			_tmp11_ = string;
			g_string_assign (_tmp11_, "");
			force_sign = FALSE;
		}
		_tmp12_ = g_string_sized_new ((gsize) 1024);
		s = _tmp12_;
		n_complex_digits = 0;
		_tmp13_ = x_im;
		_tmp14_ = s;
		_tmp15_ = serializer_cast_to_string_real (self, _tmp13_, _tmp14_, force_sign, &n_complex_digits);
		if (!_tmp15_) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = self->priv->zero_string;
			_tmp17_ = g_strdup (_tmp16_);
			result = _tmp17_;
			_g_string_free0 (s);
			_g_object_unref0 (x_im);
			_g_object_unref0 (x_real);
			_g_string_free0 (string);
			return result;
		}
		if (n_complex_digits > (*n_digits)) {
			*n_digits = n_complex_digits;
		}
		_tmp20_ = s;
		_tmp21_ = _tmp20_->str;
		_tmp22_ = self->priv->zero_string;
		if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
			_tmp19_ = TRUE;
		} else {
			GString* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp23_ = s;
			_tmp24_ = _tmp23_->str;
			_tmp25_ = self->priv->zero_string;
			_tmp26_ = g_strconcat ("+", _tmp25_, NULL);
			_tmp27_ = _tmp26_;
			_tmp19_ = g_strcmp0 (_tmp24_, _tmp27_) == 0;
			_g_free0 (_tmp27_);
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			GString* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp28_ = s;
			_tmp29_ = _tmp28_->str;
			_tmp30_ = self->priv->zero_string;
			_tmp31_ = g_strconcat ("−", _tmp30_, NULL);
			_tmp32_ = _tmp31_;
			_tmp18_ = g_strcmp0 (_tmp29_, _tmp32_) == 0;
			_g_free0 (_tmp32_);
		}
		if (_tmp18_) {
			GString* _tmp33_;
			const gchar* _tmp34_;
			_tmp33_ = string;
			_tmp34_ = _tmp33_->str;
			if (g_strcmp0 (_tmp34_, "") == 0) {
				GString* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = string;
				_tmp36_ = self->priv->zero_string;
				g_string_append (_tmp35_, _tmp36_);
			}
		} else {
			GString* _tmp37_;
			const gchar* _tmp38_;
			_tmp37_ = s;
			_tmp38_ = _tmp37_->str;
			if (g_strcmp0 (_tmp38_, "1") == 0) {
				GString* _tmp39_;
				_tmp39_ = string;
				g_string_append (_tmp39_, "i");
			} else {
				GString* _tmp40_;
				const gchar* _tmp41_;
				_tmp40_ = s;
				_tmp41_ = _tmp40_->str;
				if (g_strcmp0 (_tmp41_, "+1") == 0) {
					GString* _tmp42_;
					_tmp42_ = string;
					g_string_append (_tmp42_, "+i");
				} else {
					GString* _tmp43_;
					const gchar* _tmp44_;
					_tmp43_ = s;
					_tmp44_ = _tmp43_->str;
					if (g_strcmp0 (_tmp44_, "−1") == 0) {
						GString* _tmp45_;
						_tmp45_ = string;
						g_string_append (_tmp45_, "−i");
					} else {
						GString* _tmp46_;
						GString* _tmp47_;
						const gchar* _tmp48_;
						GString* _tmp49_;
						_tmp46_ = string;
						_tmp47_ = s;
						_tmp48_ = _tmp47_->str;
						_tmp49_ = g_string_append (_tmp46_, _tmp48_);
						g_string_append (_tmp49_, "i");
					}
				}
			}
		}
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp50_ = string;
	_tmp51_ = _tmp50_->str;
	_tmp52_ = g_strdup (_tmp51_);
	result = _tmp52_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}

static gboolean
serializer_cast_to_string_real (Serializer* self,
                                Number* x,
                                GString* string,
                                gboolean force_sign,
                                gint* n_digits)
{
	static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
	Number* number = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_;
	gint number_base = 0;
	Number* temp = NULL;
	Number* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* rounded_number = NULL;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* _tmp22_;
	Number* _tmp23_;
	gint i = 0;
	gssize last_non_zero = 0L;
	Number* _tmp43_;
	Number* _tmp44_;
	gboolean _tmp57_ = FALSE;
	gboolean _tmp58_ = FALSE;
	const gchar* _tmp59_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	g_return_val_if_fail (string != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (x);
	number = _tmp0_;
	_tmp1_ = number;
	if (number_is_negative (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = number;
		_tmp3_ = number_abs (_tmp2_);
		_g_object_unref0 (number);
		number = _tmp3_;
	}
	_tmp6_ = self->priv->_check_fixed_max;
	if (_tmp6_) {
		Number* _tmp7_;
		Number* _tmp8_;
		_tmp7_ = serializer_get_fixed_max ();
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Number* _tmp9_;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp9_ = number;
		_tmp10_ = serializer_get_fixed_max ();
		_tmp11_ = _tmp10_;
		_tmp4_ = number_compare (_tmp9_, _tmp11_) > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		serializer_set_error (self, _ ("The result is too long to display in fixed format. Try other result fo" \
"rmats"));
		result = FALSE;
		_g_object_unref0 (number);
		return result;
	}
	number_base = (gint) self->priv->representation_base;
	_tmp12_ = number_new_integer ((gint64) number_base, (gint64) 0);
	temp = _tmp12_;
	_tmp13_ = temp;
	_tmp14_ = number_xpowy_integer (_tmp13_, (gint64) (-(self->priv->trailing_digits + 1)));
	_g_object_unref0 (temp);
	temp = _tmp14_;
	_tmp15_ = temp;
	_tmp16_ = number_multiply_integer (_tmp15_, (gint64) number_base);
	_g_object_unref0 (temp);
	temp = _tmp16_;
	_tmp17_ = temp;
	_tmp18_ = number_divide_integer (_tmp17_, (gint64) 2);
	_g_object_unref0 (temp);
	temp = _tmp18_;
	_tmp19_ = number;
	_tmp20_ = temp;
	_tmp21_ = number_add (_tmp19_, _tmp20_);
	rounded_number = _tmp21_;
	_tmp22_ = rounded_number;
	_tmp23_ = number_floor (_tmp22_);
	_g_object_unref0 (temp);
	temp = _tmp23_;
	i = 0;
	{
		gboolean _tmp24_ = FALSE;
		_tmp24_ = TRUE;
		while (TRUE) {
			gboolean _tmp26_ = FALSE;
			gint _tmp27_;
			Number* t = NULL;
			Number* _tmp28_;
			Number* _tmp29_;
			Number* _tmp30_;
			Number* _tmp31_;
			Number* t2 = NULL;
			Number* _tmp32_;
			Number* _tmp33_;
			Number* t3 = NULL;
			Number* _tmp34_;
			Number* _tmp35_;
			Number* _tmp36_;
			gint64 d = 0LL;
			Number* _tmp37_;
			gboolean _tmp38_ = FALSE;
			gint _tmp40_;
			Number* _tmp41_;
			Number* _tmp42_;
			if (!_tmp24_) {
				Number* _tmp25_;
				_tmp25_ = temp;
				if (!(!number_is_zero (_tmp25_))) {
					break;
				}
			}
			_tmp24_ = FALSE;
			if (self->priv->show_tsep) {
				_tmp26_ = i == serializer_get_thousands_separator_count (self);
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				g_string_prepend_unichar (string, serializer_get_thousands_separator (self));
				i = 0;
			}
			_tmp27_ = i;
			i = _tmp27_ + 1;
			_tmp28_ = temp;
			_tmp29_ = number_divide_integer (_tmp28_, (gint64) number_base);
			t = _tmp29_;
			_tmp30_ = t;
			_tmp31_ = number_floor (_tmp30_);
			_g_object_unref0 (t);
			t = _tmp31_;
			_tmp32_ = t;
			_tmp33_ = number_multiply_integer (_tmp32_, (gint64) number_base);
			t2 = _tmp33_;
			_tmp34_ = temp;
			_tmp35_ = t2;
			_tmp36_ = number_subtract (_tmp34_, _tmp35_);
			t3 = _tmp36_;
			_tmp37_ = t3;
			d = number_to_integer (_tmp37_);
			if (d < ((gint64) 16)) {
				_tmp38_ = d >= ((gint64) 0);
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				gchar _tmp39_;
				_tmp39_ = digits[d];
				g_string_prepend_c (string, _tmp39_);
			} else {
				serializer_set_error (self, _ ("The result is too long to display in fixed format. Try other result fo" \
"rmats"));
				result = FALSE;
				_g_object_unref0 (t3);
				_g_object_unref0 (t2);
				_g_object_unref0 (t);
				_g_object_unref0 (rounded_number);
				_g_object_unref0 (temp);
				_g_object_unref0 (number);
				return result;
			}
			_tmp40_ = *n_digits;
			*n_digits = _tmp40_ + 1;
			_tmp41_ = t;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (temp);
			temp = _tmp42_;
			_g_object_unref0 (t3);
			_g_object_unref0 (t2);
			_g_object_unref0 (t);
		}
	}
	last_non_zero = string->len;
	g_string_append_unichar (string, self->priv->radix);
	_tmp43_ = rounded_number;
	_tmp44_ = number_fractional_component (_tmp43_);
	_g_object_unref0 (temp);
	temp = _tmp44_;
	{
		gboolean _tmp45_ = FALSE;
		i = 0;
		_tmp45_ = TRUE;
		while (TRUE) {
			Number* _tmp47_;
			Number* _tmp48_;
			Number* _tmp49_;
			Number* digit = NULL;
			Number* _tmp50_;
			Number* _tmp51_;
			gint64 d = 0LL;
			Number* _tmp52_;
			gchar _tmp53_;
			Number* _tmp54_;
			Number* _tmp55_;
			Number* _tmp56_;
			if (!_tmp45_) {
				gint _tmp46_;
				_tmp46_ = i;
				i = _tmp46_ + 1;
			}
			_tmp45_ = FALSE;
			if (!(i < self->priv->trailing_digits)) {
				break;
			}
			_tmp47_ = temp;
			if (number_is_zero (_tmp47_)) {
				break;
			}
			_tmp48_ = temp;
			_tmp49_ = number_multiply_integer (_tmp48_, (gint64) number_base);
			_g_object_unref0 (temp);
			temp = _tmp49_;
			_tmp50_ = temp;
			_tmp51_ = number_floor (_tmp50_);
			digit = _tmp51_;
			_tmp52_ = digit;
			d = number_to_integer (_tmp52_);
			_tmp53_ = digits[d];
			g_string_append_c (string, _tmp53_);
			if (d != ((gint64) 0)) {
				last_non_zero = string->len;
			}
			_tmp54_ = temp;
			_tmp55_ = digit;
			_tmp56_ = number_subtract (_tmp54_, _tmp55_);
			_g_object_unref0 (temp);
			temp = _tmp56_;
			_g_object_unref0 (digit);
		}
	}
	if (!self->priv->show_zeroes) {
		_tmp57_ = TRUE;
	} else {
		_tmp57_ = self->priv->trailing_digits == 0;
	}
	if (_tmp57_) {
		g_string_truncate (string, (gsize) last_non_zero);
	}
	_tmp59_ = string->str;
	if (g_strcmp0 (_tmp59_, "0") != 0) {
		_tmp58_ = TRUE;
	} else {
		_tmp58_ = force_sign;
	}
	if (_tmp58_) {
		if (number_is_negative (x)) {
			g_string_prepend (string, "−");
		} else {
			if (force_sign) {
				g_string_prepend (string, "+");
			}
		}
	}
	if (number_base != self->priv->number_base) {
		static const gchar* sub_digits[10] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
		gint multiplier = 0;
		gint b = 0;
		multiplier = 1;
		b = number_base;
		while (TRUE) {
			if (!((number_base / multiplier) != 0)) {
				break;
			}
			multiplier *= 10;
		}
		while (TRUE) {
			gint d = 0;
			const gchar* _tmp60_;
			if (!(multiplier != 1)) {
				break;
			}
			multiplier /= 10;
			d = b / multiplier;
			_tmp60_ = sub_digits[d];
			g_string_append (string, _tmp60_);
			b -= d * multiplier;
		}
	}
	result = TRUE;
	_g_object_unref0 (rounded_number);
	_g_object_unref0 (temp);
	_g_object_unref0 (number);
	return result;
}

static gchar*
serializer_cast_to_exponential_string (Serializer* self,
                                       Number* x,
                                       gboolean eng_format)
{
	GString* string = NULL;
	GString* _tmp0_;
	Number* x_real = NULL;
	Number* _tmp1_;
	gint exponent = 0;
	Number* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = g_string_sized_new ((gsize) 1024);
	string = _tmp0_;
	_tmp1_ = number_real_component (x);
	x_real = _tmp1_;
	_tmp2_ = x_real;
	_tmp3_ = string;
	exponent = serializer_cast_to_exponential_string_real (self, _tmp2_, _tmp3_, eng_format, FALSE);
	_tmp4_ = string;
	serializer_append_exponent (self, _tmp4_, exponent);
	if (number_is_complex (x)) {
		Number* x_im = NULL;
		Number* _tmp5_;
		gboolean force_sign = FALSE;
		GString* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		GString* s = NULL;
		GString* _tmp10_;
		Number* _tmp11_;
		GString* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		GString* _tmp15_;
		const gchar* _tmp16_;
		GString* _tmp34_;
		_tmp5_ = number_imaginary_component (x);
		x_im = _tmp5_;
		force_sign = TRUE;
		_tmp6_ = string;
		_tmp7_ = _tmp6_->str;
		_tmp8_ = self->priv->zero_string;
		if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
			GString* _tmp9_;
			_tmp9_ = string;
			g_string_assign (_tmp9_, "");
			force_sign = FALSE;
		}
		_tmp10_ = g_string_sized_new ((gsize) 1024);
		s = _tmp10_;
		_tmp11_ = x_im;
		_tmp12_ = s;
		exponent = serializer_cast_to_exponential_string_real (self, _tmp11_, _tmp12_, eng_format, force_sign);
		_tmp15_ = s;
		_tmp16_ = _tmp15_->str;
		if (g_strcmp0 (_tmp16_, "0") == 0) {
			_tmp14_ = TRUE;
		} else {
			GString* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = s;
			_tmp18_ = _tmp17_->str;
			_tmp14_ = g_strcmp0 (_tmp18_, "+0") == 0;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			GString* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = s;
			_tmp20_ = _tmp19_->str;
			_tmp13_ = g_strcmp0 (_tmp20_, "−0") == 0;
		}
		if (_tmp13_) {
		} else {
			GString* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = s;
			_tmp22_ = _tmp21_->str;
			if (g_strcmp0 (_tmp22_, "1") == 0) {
				GString* _tmp23_;
				_tmp23_ = string;
				g_string_append (_tmp23_, "i");
			} else {
				GString* _tmp24_;
				const gchar* _tmp25_;
				_tmp24_ = s;
				_tmp25_ = _tmp24_->str;
				if (g_strcmp0 (_tmp25_, "+1") == 0) {
					GString* _tmp26_;
					_tmp26_ = string;
					g_string_append (_tmp26_, "+i");
				} else {
					GString* _tmp27_;
					const gchar* _tmp28_;
					_tmp27_ = s;
					_tmp28_ = _tmp27_->str;
					if (g_strcmp0 (_tmp28_, "−1") == 0) {
						GString* _tmp29_;
						_tmp29_ = string;
						g_string_append (_tmp29_, "−i");
					} else {
						GString* _tmp30_;
						GString* _tmp31_;
						const gchar* _tmp32_;
						GString* _tmp33_;
						_tmp30_ = string;
						_tmp31_ = s;
						_tmp32_ = _tmp31_->str;
						_tmp33_ = g_string_append (_tmp30_, _tmp32_);
						g_string_append (_tmp33_, "i");
					}
				}
			}
		}
		_tmp34_ = string;
		serializer_append_exponent (self, _tmp34_, exponent);
		_g_string_free0 (s);
		_g_object_unref0 (x_im);
	}
	_tmp35_ = string;
	_tmp36_ = _tmp35_->str;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	_g_object_unref0 (x_real);
	_g_string_free0 (string);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static gint
serializer_cast_to_exponential_string_real (Serializer* self,
                                            Number* x,
                                            GString* string,
                                            gboolean eng_format,
                                            gboolean force_sign)
{
	Number* mantissa = NULL;
	Number* _tmp0_;
	gint exponent = 0;
	Number* _tmp1_;
	gint n_digits = 0;
	gchar* mantissa_string = NULL;
	Number* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp28_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (x != NULL, 0);
	g_return_val_if_fail (string != NULL, 0);
	if (number_is_negative (x)) {
		g_string_append (string, "−");
	} else {
		if (force_sign) {
			g_string_append (string, "+");
		}
	}
	_tmp0_ = number_abs (x);
	mantissa = _tmp0_;
	exponent = 0;
	_tmp1_ = mantissa;
	if (!number_is_zero (_tmp1_)) {
		Number* base_ = NULL;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		gboolean _tmp9_ = FALSE;
		Number* _tmp11_;
		Number* _tmp12_;
		Number* _tmp13_;
		Number* _tmp14_;
		Number* _tmp15_;
		_tmp2_ = number_new_integer ((gint64) self->priv->number_base, (gint64) 0);
		base_ = _tmp2_;
		_tmp3_ = mantissa;
		_tmp4_ = base_;
		_tmp5_ = number_logarithm (_tmp3_, _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_floor (_tmp6_);
		_tmp8_ = _tmp7_;
		exponent = (gint) number_to_integer (_tmp8_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		if (eng_format) {
			_tmp9_ = (exponent % 3) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gint _tmp10_ = 0;
			if (exponent > 0) {
				_tmp10_ = exponent % 3;
			} else {
				_tmp10_ = (exponent % 3) + 3;
			}
			exponent -= _tmp10_;
		}
		_tmp11_ = mantissa;
		_tmp12_ = base_;
		_tmp13_ = number_xpowy_integer (_tmp12_, (gint64) exponent);
		_tmp14_ = _tmp13_;
		_tmp15_ = number_divide (_tmp11_, _tmp14_);
		_g_object_unref0 (mantissa);
		mantissa = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (base_);
	}
	n_digits = 0;
	_tmp16_ = mantissa;
	_tmp17_ = serializer_cast_to_string (self, _tmp16_, &n_digits);
	mantissa_string = _tmp17_;
	if (eng_format) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp18_ = mantissa_string;
		_tmp19_ = g_unichar_to_string (self->priv->tsep);
		_tmp20_ = _tmp19_;
		_tmp21_ = string_replace (_tmp18_, _tmp20_, "");
		_g_free0 (mantissa_string);
		mantissa_string = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp22_ = mantissa_string;
		if (g_str_has_prefix (_tmp22_, "1000")) {
			const gchar* _tmp23_;
			gchar* _tmp24_;
			exponent += 3;
			_tmp23_ = mantissa_string;
			_tmp24_ = string_splice (_tmp23_, (glong) 0, (glong) 4, "1");
			_g_free0 (mantissa_string);
			mantissa_string = _tmp24_;
		}
	} else {
		const gchar* _tmp25_;
		_tmp25_ = mantissa_string;
		if (g_str_has_prefix (_tmp25_, "10")) {
			const gchar* _tmp26_;
			gchar* _tmp27_;
			exponent += 1;
			_tmp26_ = mantissa_string;
			_tmp27_ = string_splice (_tmp26_, (glong) 0, (glong) 2, "1");
			_g_free0 (mantissa_string);
			mantissa_string = _tmp27_;
		}
	}
	_tmp28_ = mantissa_string;
	g_string_append (string, _tmp28_);
	result = exponent;
	_g_free0 (mantissa_string);
	_g_object_unref0 (mantissa);
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
serializer_append_exponent (Serializer* self,
                            GString* string,
                            gint exponent)
{
	static const gunichar super_digits[10] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
	gchar* super_value = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (string != NULL);
	if (exponent == 0) {
		return;
	}
	g_string_append (string, "×10");
	if (exponent < 0) {
		exponent = -exponent;
		g_string_append_unichar (string, 8315U);
	}
	_tmp0_ = g_strdup_printf ("%d", exponent);
	super_value = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				const gchar* _tmp6_;
				gunichar _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = super_value;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = super_value;
				_tmp7_ = super_digits[string_get (_tmp6_, (glong) i) - '0'];
				g_string_append_unichar (string, _tmp7_);
			}
		}
	}
	_g_free0 (super_value);
}

const gchar*
serializer_get_error (Serializer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error;
	result = _tmp0_;
	return result;
}

void
serializer_set_error (Serializer* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = serializer_get_error (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_error);
		self->priv->_error = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, serializer_properties[SERIALIZER_ERROR_PROPERTY]);
	}
}

gboolean
serializer_get_check_fixed_max (Serializer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_check_fixed_max;
	return result;
}

void
serializer_set_check_fixed_max (Serializer* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = serializer_get_check_fixed_max (self);
	if (old_value != value) {
		self->priv->_check_fixed_max = value;
		g_object_notify_by_pspec ((GObject *) self, serializer_properties[SERIALIZER_CHECK_FIXED_MAX_PROPERTY]);
	}
}

Number*
serializer_get_fixed_max (void)
{
	Number* result;
	Number* _tmp0_;
	_tmp0_ = serializer__fixed_max;
	result = _tmp0_;
	return result;
}

void
serializer_set_fixed_max (Number* value)
{
	Number* _tmp0_;
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (serializer__fixed_max);
	serializer__fixed_max = _tmp0_;
}

static void
serializer_class_init (SerializerClass * klass,
                       gpointer klass_data)
{
	serializer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Serializer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_serializer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_serializer_set_property;
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_ERROR_PROPERTY, serializer_properties[SERIALIZER_ERROR_PROPERTY] = g_param_spec_string ("error", "error", "error", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_CHECK_FIXED_MAX_PROPERTY, serializer_properties[SERIALIZER_CHECK_FIXED_MAX_PROPERTY] = g_param_spec_boolean ("check-fixed-max", "check-fixed-max", "check-fixed-max", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
serializer_instance_init (Serializer * self,
                          gpointer klass)
{
	self->priv = serializer_get_instance_private (self);
	self->priv->_error = NULL;
	self->priv->_check_fixed_max = TRUE;
}

static void
serializer_finalize (GObject * obj)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
	_g_free0 (self->priv->zero_string);
	_g_free0 (self->priv->_error);
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
serializer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
	GType serializer_type_id;
	serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
	Serializer_private_offset = g_type_add_instance_private (serializer_type_id, sizeof (SerializerPrivate));
	return serializer_type_id;
}

GType
serializer_get_type (void)
{
	static gsize serializer_type_id__once = 0;
	if (g_once_init_enter (&serializer_type_id__once)) {
		GType serializer_type_id;
		serializer_type_id = serializer_get_type_once ();
		g_once_init_leave (&serializer_type_id__once, serializer_type_id);
	}
	return serializer_type_id__once;
}

static void
_vala_serializer_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		g_value_set_string (value, serializer_get_error (self));
		break;
		case SERIALIZER_CHECK_FIXED_MAX_PROPERTY:
		g_value_set_boolean (value, serializer_get_check_fixed_max (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_serializer_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
	switch (property_id) {
		case SERIALIZER_ERROR_PROPERTY:
		serializer_set_error (self, g_value_get_string (value));
		break;
		case SERIALIZER_CHECK_FIXED_MAX_PROPERTY:
		serializer_set_check_fixed_max (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

