/* FavoritesManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FavoritesManager.vala, do not modify */

/*
 * Copyright 2026 Ubuntu Budgie Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "slingshot.h"
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_FAVORITES_MANAGER_0_PROPERTY,
	SLINGSHOT_BACKEND_FAVORITES_MANAGER_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_favorites_manager_properties[SLINGSHOT_BACKEND_FAVORITES_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL,
	SLINGSHOT_BACKEND_FAVORITES_MANAGER_NUM_SIGNALS
};
static guint slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_NUM_SIGNALS] = {0};

struct _SlingshotBackendFavoritesManagerPrivate {
	GSettings* settings;
	GeeArrayList* favorites_list;
};

static gint SlingshotBackendFavoritesManager_private_offset;
static gpointer slingshot_backend_favorites_manager_parent_class = NULL;
static SlingshotBackendFavoritesManager* slingshot_backend_favorites_manager_instance;
static SlingshotBackendFavoritesManager* slingshot_backend_favorites_manager_instance = NULL;
static GType slingshot_backend_favorites_manager_type_id = 0;

static void slingshot_backend_favorites_manager_load_favorites (SlingshotBackendFavoritesManager* self);
static void slingshot_backend_favorites_manager_save_favorites (SlingshotBackendFavoritesManager* self);
static GObject * slingshot_backend_favorites_manager_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void _slingshot_backend_favorites_manager___lambda36_ (SlingshotBackendFavoritesManager* self);
static void __slingshot_backend_favorites_manager___lambda36__g_settings_changed (GSettings* _sender,
                                                                           const gchar* key,
                                                                           gpointer self);
static void slingshot_backend_favorites_manager_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_backend_favorites_manager_get_instance_private (SlingshotBackendFavoritesManager* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendFavoritesManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SlingshotBackendFavoritesManager*
slingshot_backend_favorites_manager_get_default (void)
{
	SlingshotBackendFavoritesManager* _tmp0_;
	SlingshotBackendFavoritesManager* _tmp2_;
	SlingshotBackendFavoritesManager* _tmp3_;
	SlingshotBackendFavoritesManager* result;
	_tmp0_ = slingshot_backend_favorites_manager_instance;
	if (_tmp0_ == NULL) {
		SlingshotBackendFavoritesManager* _tmp1_;
		_tmp1_ = slingshot_backend_favorites_manager_new ();
		_g_object_unref0 (slingshot_backend_favorites_manager_instance);
		slingshot_backend_favorites_manager_instance = _tmp1_;
	}
	_tmp2_ = slingshot_backend_favorites_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
slingshot_backend_favorites_manager_load_favorites (SlingshotBackendFavoritesManager* self)
{
	GeeArrayList* _tmp0_;
	gchar** favs = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint favs_length1;
	gint _favs_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->favorites_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "favorites");
	favs = _tmp3_;
	favs_length1 = _vala_array_length (_tmp2_);
	_favs_size_ = favs_length1;
	_tmp4_ = favs;
	_tmp4__length1 = favs_length1;
	{
		gchar** fav_collection = NULL;
		gint fav_collection_length1 = 0;
		gint _fav_collection_size_ = 0;
		gint fav_it = 0;
		fav_collection = _tmp4_;
		fav_collection_length1 = _tmp4__length1;
		for (fav_it = 0; fav_it < fav_collection_length1; fav_it = fav_it + 1) {
			const gchar* fav = NULL;
			fav = fav_collection[fav_it];
			{
				GeeArrayList* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = self->priv->favorites_list;
				_tmp6_ = fav;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
			}
		}
	}
	favs = (_vala_array_free (favs, favs_length1, (GDestroyNotify) g_free), NULL);
}

static void
slingshot_backend_favorites_manager_save_favorites (SlingshotBackendFavoritesManager* self)
{
	gchar** favs = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gint favs_length1;
	gint _favs_size_;
	gint i = 0;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->favorites_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gchar*, _tmp2_ + 1);
	favs = _tmp3_;
	favs_length1 = _tmp2_;
	_favs_size_ = favs_length1;
	i = 0;
	{
		GeeArrayList* _desktop_id_list = NULL;
		GeeArrayList* _tmp4_;
		gint _desktop_id_size = 0;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _desktop_id_index = 0;
		_tmp4_ = self->priv->favorites_list;
		_desktop_id_list = _tmp4_;
		_tmp5_ = _desktop_id_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_desktop_id_size = _tmp7_;
		_desktop_id_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gchar* desktop_id = NULL;
			GeeArrayList* _tmp10_;
			gpointer _tmp11_;
			gchar** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_desktop_id_index = _desktop_id_index + 1;
			_tmp8_ = _desktop_id_index;
			_tmp9_ = _desktop_id_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _desktop_id_list;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _desktop_id_index);
			desktop_id = (gchar*) _tmp11_;
			_tmp12_ = favs;
			_tmp12__length1 = favs_length1;
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_tmp14_ = desktop_id;
			_tmp15_ = g_strdup (_tmp14_);
			_g_free0 (_tmp12_[_tmp13_]);
			_tmp12_[_tmp13_] = _tmp15_;
			_g_free0 (desktop_id);
		}
	}
	_tmp16_ = self->priv->settings;
	_tmp17_ = favs;
	_tmp17__length1 = favs_length1;
	g_settings_set_strv (_tmp16_, "favorites", _tmp17_);
	favs = (_vala_array_free (favs, favs_length1, (GDestroyNotify) g_free), NULL);
}

void
slingshot_backend_favorites_manager_add_favorite (SlingshotBackendFavoritesManager* self,
                                                  const gchar* desktop_id)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desktop_id != NULL);
	_tmp0_ = self->priv->favorites_list;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, desktop_id)) {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->priv->favorites_list;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, desktop_id);
		slingshot_backend_favorites_manager_save_favorites (self);
		g_signal_emit (self, slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL], 0);
	}
}

void
slingshot_backend_favorites_manager_remove_favorite (SlingshotBackendFavoritesManager* self,
                                                     const gchar* desktop_id)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (desktop_id != NULL);
	_tmp0_ = self->priv->favorites_list;
	if (gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, desktop_id)) {
		slingshot_backend_favorites_manager_save_favorites (self);
		g_signal_emit (self, slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL], 0);
	}
}

gboolean
slingshot_backend_favorites_manager_is_favorite (SlingshotBackendFavoritesManager* self,
                                                 const gchar* desktop_id)
{
	GeeArrayList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (desktop_id != NULL, FALSE);
	_tmp0_ = self->priv->favorites_list;
	result = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp0_, desktop_id);
	return result;
}

void
slingshot_backend_favorites_manager_move_favorite (SlingshotBackendFavoritesManager* self,
                                                   gint old_index,
                                                   gint new_index)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* item = NULL;
	GeeArrayList* _tmp9_;
	gpointer _tmp10_;
	GeeArrayList* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	GeeArrayList* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	if (old_index < 0) {
		_tmp2_ = TRUE;
	} else {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->favorites_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp2_ = old_index >= _tmp5_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = new_index < 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->favorites_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp0_ = new_index >= _tmp8_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = self->priv->favorites_list;
	_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, old_index);
	item = (gchar*) _tmp10_;
	_tmp11_ = self->priv->favorites_list;
	_tmp12_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp11_, old_index);
	_tmp13_ = (gchar*) _tmp12_;
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->favorites_list;
	_tmp15_ = item;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp14_, new_index, _tmp15_);
	slingshot_backend_favorites_manager_save_favorites (self);
	g_signal_emit (self, slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL], 0);
	_g_free0 (item);
}

GeeList*
slingshot_backend_favorites_manager_get_favorites (SlingshotBackendFavoritesManager* self)
{
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->favorites_list;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = (GeeList*) _tmp2_;
	return result;
}

void
slingshot_backend_favorites_manager_validate_favorites (SlingshotBackendFavoritesManager* self)
{
	GeeArrayList* to_remove = NULL;
	GeeArrayList* _tmp0_;
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp1_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	to_remove = _tmp0_;
	_tmp1_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp1_;
	{
		GeeArrayList* _desktop_id_list = NULL;
		GeeArrayList* _tmp2_;
		gint _desktop_id_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _desktop_id_index = 0;
		_tmp2_ = self->priv->favorites_list;
		_desktop_id_list = _tmp2_;
		_tmp3_ = _desktop_id_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_desktop_id_size = _tmp5_;
		_desktop_id_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* desktop_id = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			SynapseDesktopFileInfo* info = NULL;
			SynapseDesktopFileService* _tmp10_;
			const gchar* _tmp11_;
			SynapseDesktopFileInfo* _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			SynapseDesktopFileInfo* _tmp15_;
			_desktop_id_index = _desktop_id_index + 1;
			_tmp6_ = _desktop_id_index;
			_tmp7_ = _desktop_id_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _desktop_id_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _desktop_id_index);
			desktop_id = (gchar*) _tmp9_;
			_tmp10_ = dfs;
			_tmp11_ = desktop_id;
			_tmp12_ = synapse_desktop_file_service_get_desktop_file_for_id (_tmp10_, _tmp11_);
			info = _tmp12_;
			_tmp15_ = info;
			if (_tmp15_ == NULL) {
				_tmp14_ = TRUE;
			} else {
				SynapseDesktopFileInfo* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = info;
				_tmp17_ = synapse_desktop_file_info_get_is_hidden (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_;
			}
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				SynapseDesktopFileInfo* _tmp19_;
				gboolean _tmp20_;
				gboolean _tmp21_;
				_tmp19_ = info;
				_tmp20_ = synapse_desktop_file_info_get_is_valid (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp13_ = !_tmp21_;
			}
			if (_tmp13_) {
				GeeArrayList* _tmp22_;
				const gchar* _tmp23_;
				_tmp22_ = to_remove;
				_tmp23_ = desktop_id;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
			}
			_g_object_unref0 (info);
			_g_free0 (desktop_id);
		}
	}
	changed = FALSE;
	{
		GeeArrayList* _desktop_id_list = NULL;
		GeeArrayList* _tmp24_;
		gint _desktop_id_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _desktop_id_index = 0;
		_tmp24_ = to_remove;
		_desktop_id_list = _tmp24_;
		_tmp25_ = _desktop_id_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_desktop_id_size = _tmp27_;
		_desktop_id_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gchar* desktop_id = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			GeeArrayList* _tmp32_;
			const gchar* _tmp33_;
			_desktop_id_index = _desktop_id_index + 1;
			_tmp28_ = _desktop_id_index;
			_tmp29_ = _desktop_id_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _desktop_id_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _desktop_id_index);
			desktop_id = (gchar*) _tmp31_;
			_tmp32_ = self->priv->favorites_list;
			_tmp33_ = desktop_id;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp32_, _tmp33_);
			changed = TRUE;
			_g_free0 (desktop_id);
		}
	}
	if (changed) {
		slingshot_backend_favorites_manager_save_favorites (self);
		g_signal_emit (self, slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL], 0);
	}
	_g_object_unref0 (dfs);
	_g_object_unref0 (to_remove);
}

SlingshotBackendFavoritesManager*
slingshot_backend_favorites_manager_construct (GType object_type)
{
	SlingshotBackendFavoritesManager * self = NULL;
	self = (SlingshotBackendFavoritesManager*) g_object_new (object_type, NULL);
	return self;
}

SlingshotBackendFavoritesManager*
slingshot_backend_favorites_manager_new (void)
{
	return slingshot_backend_favorites_manager_construct (SLINGSHOT_BACKEND_TYPE_FAVORITES_MANAGER);
}

static void
_slingshot_backend_favorites_manager___lambda36_ (SlingshotBackendFavoritesManager* self)
{
	slingshot_backend_favorites_manager_load_favorites (self);
	g_signal_emit (self, slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL], 0);
}

static void
__slingshot_backend_favorites_manager___lambda36__g_settings_changed (GSettings* _sender,
                                                                      const gchar* key,
                                                                      gpointer self)
{
	_slingshot_backend_favorites_manager___lambda36_ ((SlingshotBackendFavoritesManager*) self);
}

static GObject *
slingshot_backend_favorites_manager_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendFavoritesManager * self;
	GSettings* _tmp0_;
	GeeArrayList* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_favorites_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_FAVORITES_MANAGER, SlingshotBackendFavoritesManager);
	_tmp0_ = g_settings_new ("org.ubuntubudgie.plugins.budgie-appmenu");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->favorites_list);
	self->priv->favorites_list = _tmp1_;
	slingshot_backend_favorites_manager_load_favorites (self);
	_tmp2_ = self->priv->settings;
	g_signal_connect_object (_tmp2_, "changed::favorites", (GCallback) __slingshot_backend_favorites_manager___lambda36__g_settings_changed, self, 0);
	return obj;
}

static void
slingshot_backend_favorites_manager_class_init (SlingshotBackendFavoritesManagerClass * klass,
                                                gpointer klass_data)
{
	slingshot_backend_favorites_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendFavoritesManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_favorites_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_favorites_manager_finalize;
	slingshot_backend_favorites_manager_signals[SLINGSHOT_BACKEND_FAVORITES_MANAGER_FAVORITES_CHANGED_SIGNAL] = g_signal_new ("favorites-changed", SLINGSHOT_BACKEND_TYPE_FAVORITES_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_backend_favorites_manager_instance_init (SlingshotBackendFavoritesManager * self,
                                                   gpointer klass)
{
	self->priv = slingshot_backend_favorites_manager_get_instance_private (self);
}

static void
slingshot_backend_favorites_manager_finalize (GObject * obj)
{
	SlingshotBackendFavoritesManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_FAVORITES_MANAGER, SlingshotBackendFavoritesManager);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->favorites_list);
	G_OBJECT_CLASS (slingshot_backend_favorites_manager_parent_class)->finalize (obj);
}

GType
slingshot_backend_favorites_manager_get_type (void)
{
	return slingshot_backend_favorites_manager_type_id;
}

GType
slingshot_backend_favorites_manager_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendFavoritesManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_favorites_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendFavoritesManager), 0, (GInstanceInitFunc) slingshot_backend_favorites_manager_instance_init, NULL };
	slingshot_backend_favorites_manager_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SlingshotBackendFavoritesManager", &g_define_type_info, 0);
	SlingshotBackendFavoritesManager_private_offset = sizeof (SlingshotBackendFavoritesManagerPrivate);
	return slingshot_backend_favorites_manager_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

