/* alarm-day-picker-row.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from alarm-day-picker-row.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2020  Zander Brown <zbrown@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CLOCKS_ALARM_TYPE_DAY_PICKER_ROW (clocks_alarm_day_picker_row_get_type ())
#define CLOCKS_ALARM_DAY_PICKER_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow))
#define CLOCKS_ALARM_DAY_PICKER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRowClass))
#define CLOCKS_ALARM_IS_DAY_PICKER_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW))
#define CLOCKS_ALARM_IS_DAY_PICKER_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW))
#define CLOCKS_ALARM_DAY_PICKER_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRowClass))

typedef struct _ClocksAlarmDayPickerRow ClocksAlarmDayPickerRow;
typedef struct _ClocksAlarmDayPickerRowClass ClocksAlarmDayPickerRowClass;
typedef struct _ClocksAlarmDayPickerRowPrivate ClocksAlarmDayPickerRowPrivate;

#define CLOCKS_UTILS_TYPE_WEEKDAYS (clocks_utils_weekdays_get_type ())
#define CLOCKS_UTILS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdays))
#define CLOCKS_UTILS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))
#define CLOCKS_UTILS_IS_WEEKDAYS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_IS_WEEKDAYS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_WEEKDAYS))
#define CLOCKS_UTILS_WEEKDAYS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_WEEKDAYS, ClocksUtilsWeekdaysClass))

typedef struct _ClocksUtilsWeekdays ClocksUtilsWeekdays;
typedef struct _ClocksUtilsWeekdaysClass ClocksUtilsWeekdaysClass;
enum  {
	CLOCKS_ALARM_DAY_PICKER_ROW_0_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY,
	CLOCKS_ALARM_DAY_PICKER_ROW_NUM_PROPERTIES
};
static GParamSpec* clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_NUM_PROPERTIES];
#define _clocks_utils_weekdays_unref0(var) ((var == NULL) ? NULL : (var = (clocks_utils_weekdays_unref (var), NULL)))
typedef enum  {
	CLOCKS_UTILS_WEEKDAYS_DAY_MON = 0,
	CLOCKS_UTILS_WEEKDAYS_DAY_TUE,
	CLOCKS_UTILS_WEEKDAYS_DAY_WED,
	CLOCKS_UTILS_WEEKDAYS_DAY_THU,
	CLOCKS_UTILS_WEEKDAYS_DAY_FRI,
	CLOCKS_UTILS_WEEKDAYS_DAY_SAT,
	CLOCKS_UTILS_WEEKDAYS_DAY_SUN
} ClocksUtilsWeekdaysDay;

#define CLOCKS_UTILS_WEEKDAYS_TYPE_DAY (clocks_utils_weekdays_day_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CLOCKS_ALARM_DAY_PICKER_ROW_DAYS_CHANGED_SIGNAL,
	CLOCKS_ALARM_DAY_PICKER_ROW_NUM_SIGNALS
};
static guint clocks_alarm_day_picker_row_signals[CLOCKS_ALARM_DAY_PICKER_ROW_NUM_SIGNALS] = {0};

struct _ClocksAlarmDayPickerRow {
	AdwPreferencesRow parent_instance;
	ClocksAlarmDayPickerRowPrivate * priv;
};

struct _ClocksAlarmDayPickerRowClass {
	AdwPreferencesRowClass parent_class;
};

struct _ClocksAlarmDayPickerRowPrivate {
	ClocksUtilsWeekdays* days;
	GtkBox* box;
};

static gint ClocksAlarmDayPickerRow_private_offset;
static gpointer clocks_alarm_day_picker_row_parent_class = NULL;

VALA_EXTERN GType clocks_alarm_day_picker_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksAlarmDayPickerRow, g_object_unref)
VALA_EXTERN gpointer clocks_utils_weekdays_ref (gpointer instance);
VALA_EXTERN void clocks_utils_weekdays_unref (gpointer instance);
VALA_EXTERN GParamSpec* clocks_utils_param_spec_weekdays (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void clocks_utils_value_set_weekdays (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void clocks_utils_value_take_weekdays (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer clocks_utils_value_get_weekdays (const GValue* value);
VALA_EXTERN GType clocks_utils_weekdays_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ClocksUtilsWeekdays, clocks_utils_weekdays_unref)
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_new (void);
VALA_EXTERN ClocksUtilsWeekdays* clocks_utils_weekdays_construct (GType object_type);
VALA_EXTERN void clocks_alarm_day_picker_row_load (ClocksAlarmDayPickerRow* self,
                                       ClocksUtilsWeekdays* current_days);
VALA_EXTERN GType clocks_utils_weekdays_day_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void clocks_utils_weekdays_set (ClocksUtilsWeekdays* self,
                                ClocksUtilsWeekdaysDay d,
                                gboolean on);
VALA_EXTERN gboolean clocks_utils_weekdays_get (ClocksUtilsWeekdays* self,
                                    ClocksUtilsWeekdaysDay d);
static void clocks_alarm_day_picker_row_update (ClocksAlarmDayPickerRow* self);
VALA_EXTERN ClocksUtilsWeekdays* clocks_alarm_day_picker_row_store (ClocksAlarmDayPickerRow* self);
VALA_EXTERN ClocksAlarmDayPickerRow* clocks_alarm_day_picker_row_new (void);
VALA_EXTERN ClocksAlarmDayPickerRow* clocks_alarm_day_picker_row_construct (GType object_type);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_monday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_monday (ClocksAlarmDayPickerRow* self,
                                             gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_tuesday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_tuesday (ClocksAlarmDayPickerRow* self,
                                              gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_wednesday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_wednesday (ClocksAlarmDayPickerRow* self,
                                                gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_thursday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_thursday (ClocksAlarmDayPickerRow* self,
                                               gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_friday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_friday (ClocksAlarmDayPickerRow* self,
                                             gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_saturday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_saturday (ClocksAlarmDayPickerRow* self,
                                               gboolean value);
VALA_EXTERN gboolean clocks_alarm_day_picker_row_get_sunday (ClocksAlarmDayPickerRow* self);
VALA_EXTERN void clocks_alarm_day_picker_row_set_sunday (ClocksAlarmDayPickerRow* self,
                                             gboolean value);
static GObject * clocks_alarm_day_picker_row_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
VALA_EXTERN gchar* clocks_utils_weekdays_day_symbol (ClocksUtilsWeekdaysDay self);
VALA_EXTERN gchar* clocks_utils_weekdays_day_name (ClocksUtilsWeekdaysDay self);
VALA_EXTERN ClocksUtilsWeekdaysDay clocks_utils_weekdays_day_get_first_weekday (void);
static void clocks_alarm_day_picker_row_finalize (GObject * obj);
static GType clocks_alarm_day_picker_row_get_type_once (void);
static void _vala_clocks_alarm_day_picker_row_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_clocks_alarm_day_picker_row_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
clocks_alarm_day_picker_row_get_instance_private (ClocksAlarmDayPickerRow* self)
{
	return G_STRUCT_MEMBER_P (self, ClocksAlarmDayPickerRow_private_offset);
}

void
clocks_alarm_day_picker_row_load (ClocksAlarmDayPickerRow* self,
                                  ClocksUtilsWeekdays* current_days)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_days != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ClocksUtilsWeekdays* _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				_tmp2_ = self->priv->days;
				clocks_utils_weekdays_set (_tmp2_, (ClocksUtilsWeekdaysDay) i, clocks_utils_weekdays_get (current_days, (ClocksUtilsWeekdaysDay) i));
			}
		}
	}
	g_object_notify ((GObject*) self, "monday");
	g_object_notify ((GObject*) self, "tuesday");
	g_object_notify ((GObject*) self, "wednesday");
	g_object_notify ((GObject*) self, "thursday");
	g_object_notify ((GObject*) self, "friday");
	g_object_notify ((GObject*) self, "saturday");
	g_object_notify ((GObject*) self, "sunday");
	clocks_alarm_day_picker_row_update (self);
}

ClocksUtilsWeekdays*
clocks_alarm_day_picker_row_store (ClocksAlarmDayPickerRow* self)
{
	ClocksUtilsWeekdays* new_days = NULL;
	ClocksUtilsWeekdays* _tmp0_;
	ClocksUtilsWeekdays* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clocks_utils_weekdays_new ();
	new_days = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ClocksUtilsWeekdays* _tmp3_;
				ClocksUtilsWeekdays* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				_tmp3_ = new_days;
				_tmp4_ = self->priv->days;
				clocks_utils_weekdays_set (_tmp3_, (ClocksUtilsWeekdaysDay) i, clocks_utils_weekdays_get (_tmp4_, (ClocksUtilsWeekdaysDay) i));
			}
		}
	}
	result = new_days;
	return result;
}

static void
clocks_alarm_day_picker_row_update (ClocksAlarmDayPickerRow* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, clocks_alarm_day_picker_row_signals[CLOCKS_ALARM_DAY_PICKER_ROW_DAYS_CHANGED_SIGNAL], 0);
}

ClocksAlarmDayPickerRow*
clocks_alarm_day_picker_row_construct (GType object_type)
{
	ClocksAlarmDayPickerRow * self = NULL;
	self = (ClocksAlarmDayPickerRow*) g_object_new (object_type, NULL);
	return self;
}

ClocksAlarmDayPickerRow*
clocks_alarm_day_picker_row_new (void)
{
	return clocks_alarm_day_picker_row_construct (CLOCKS_ALARM_TYPE_DAY_PICKER_ROW);
}

gboolean
clocks_alarm_day_picker_row_get_monday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_MON);
	return result;
}

void
clocks_alarm_day_picker_row_set_monday (ClocksAlarmDayPickerRow* self,
                                        gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_MON, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_tuesday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_TUE);
	return result;
}

void
clocks_alarm_day_picker_row_set_tuesday (ClocksAlarmDayPickerRow* self,
                                         gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_TUE, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_wednesday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_WED);
	return result;
}

void
clocks_alarm_day_picker_row_set_wednesday (ClocksAlarmDayPickerRow* self,
                                           gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_WED, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_thursday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_THU);
	return result;
}

void
clocks_alarm_day_picker_row_set_thursday (ClocksAlarmDayPickerRow* self,
                                          gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_THU, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_friday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_FRI);
	return result;
}

void
clocks_alarm_day_picker_row_set_friday (ClocksAlarmDayPickerRow* self,
                                        gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_FRI, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_saturday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_SAT);
	return result;
}

void
clocks_alarm_day_picker_row_set_saturday (ClocksAlarmDayPickerRow* self,
                                          gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_SAT, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY]);
}

gboolean
clocks_alarm_day_picker_row_get_sunday (ClocksAlarmDayPickerRow* self)
{
	gboolean result;
	ClocksUtilsWeekdays* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->days;
	result = clocks_utils_weekdays_get (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_SUN);
	return result;
}

void
clocks_alarm_day_picker_row_set_sunday (ClocksAlarmDayPickerRow* self,
                                        gboolean value)
{
	ClocksUtilsWeekdays* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->days;
	clocks_utils_weekdays_set (_tmp0_, CLOCKS_UTILS_WEEKDAYS_DAY_SUN, value);
	clocks_alarm_day_picker_row_update (self);
	g_object_notify_by_pspec ((GObject *) self, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY]);
}

static GObject *
clocks_alarm_day_picker_row_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ClocksAlarmDayPickerRow * self;
	GSimpleActionGroup* group = NULL;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GPropertyAction* _tmp2_;
	GPropertyAction* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	GPropertyAction* _tmp5_;
	GPropertyAction* _tmp6_;
	GSimpleActionGroup* _tmp7_;
	GPropertyAction* _tmp8_;
	GPropertyAction* _tmp9_;
	GSimpleActionGroup* _tmp10_;
	GPropertyAction* _tmp11_;
	GPropertyAction* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GPropertyAction* _tmp14_;
	GPropertyAction* _tmp15_;
	GSimpleActionGroup* _tmp16_;
	GPropertyAction* _tmp17_;
	GPropertyAction* _tmp18_;
	GSimpleActionGroup* _tmp19_;
	GPropertyAction* _tmp20_;
	GPropertyAction* _tmp21_;
	GSimpleActionGroup* _tmp22_;
	GtkToggleButton** buttons = NULL;
	GtkToggleButton** _tmp23_;
	gint buttons_length1;
	gint _buttons_size_;
	ClocksUtilsWeekdaysDay first_weekday = 0;
	parent_class = G_OBJECT_CLASS (clocks_alarm_day_picker_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow);
	_tmp0_ = g_simple_action_group_new ();
	group = _tmp0_;
	_tmp1_ = group;
	_tmp2_ = g_property_action_new ("day-0", (GObject*) self, "monday");
	_tmp3_ = _tmp2_;
	g_action_map_add_action ((GActionMap*) _tmp1_, (GAction*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = group;
	_tmp5_ = g_property_action_new ("day-1", (GObject*) self, "tuesday");
	_tmp6_ = _tmp5_;
	g_action_map_add_action ((GActionMap*) _tmp4_, (GAction*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = group;
	_tmp8_ = g_property_action_new ("day-2", (GObject*) self, "wednesday");
	_tmp9_ = _tmp8_;
	g_action_map_add_action ((GActionMap*) _tmp7_, (GAction*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = group;
	_tmp11_ = g_property_action_new ("day-3", (GObject*) self, "thursday");
	_tmp12_ = _tmp11_;
	g_action_map_add_action ((GActionMap*) _tmp10_, (GAction*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = group;
	_tmp14_ = g_property_action_new ("day-4", (GObject*) self, "friday");
	_tmp15_ = _tmp14_;
	g_action_map_add_action ((GActionMap*) _tmp13_, (GAction*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = group;
	_tmp17_ = g_property_action_new ("day-5", (GObject*) self, "saturday");
	_tmp18_ = _tmp17_;
	g_action_map_add_action ((GActionMap*) _tmp16_, (GAction*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = group;
	_tmp20_ = g_property_action_new ("day-6", (GObject*) self, "sunday");
	_tmp21_ = _tmp20_;
	g_action_map_add_action ((GActionMap*) _tmp19_, (GAction*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "repeats", (GActionGroup*) _tmp22_);
	_tmp23_ = g_new0 (GtkToggleButton*, 7 + 1);
	buttons = _tmp23_;
	buttons_length1 = 7;
	_buttons_size_ = buttons_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ClocksUtilsWeekdaysDay day = 0;
				GtkToggleButton** _tmp26_;
				gint _tmp26__length1;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GtkToggleButton* _tmp29_;
				GtkToggleButton** _tmp30_;
				gint _tmp30__length1;
				GtkToggleButton* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				GtkToggleButton** _tmp34_;
				gint _tmp34__length1;
				GtkToggleButton* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				GtkToggleButton** _tmp38_;
				gint _tmp38__length1;
				GtkToggleButton* _tmp39_;
				GtkToggleButton** _tmp40_;
				gint _tmp40__length1;
				GtkToggleButton* _tmp41_;
				GtkToggleButton** _tmp42_;
				gint _tmp42__length1;
				GtkToggleButton* _tmp43_;
				GtkWidget* _tmp44_;
				GtkToggleButton** _tmp45_;
				gint _tmp45__length1;
				GtkToggleButton* _tmp46_;
				GtkToggleButton** _tmp47_;
				gint _tmp47__length1;
				GtkToggleButton* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				day = (ClocksUtilsWeekdaysDay) i;
				_tmp26_ = buttons;
				_tmp26__length1 = buttons_length1;
				_tmp27_ = clocks_utils_weekdays_day_symbol (day);
				_tmp28_ = _tmp27_;
				_tmp29_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_tmp28_);
				g_object_ref_sink (_tmp29_);
				_g_object_unref0 (_tmp26_[i]);
				_tmp26_[i] = _tmp29_;
				_g_free0 (_tmp28_);
				_tmp30_ = buttons;
				_tmp30__length1 = buttons_length1;
				_tmp31_ = _tmp30_[i];
				_tmp32_ = g_strdup_printf ("repeats.day-%i", i);
				_tmp33_ = _tmp32_;
				gtk_actionable_set_action_name ((GtkActionable*) _tmp31_, _tmp33_);
				_g_free0 (_tmp33_);
				_tmp34_ = buttons;
				_tmp34__length1 = buttons_length1;
				_tmp35_ = _tmp34_[i];
				_tmp36_ = clocks_utils_weekdays_day_name (day);
				_tmp37_ = _tmp36_;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp37_);
				_g_free0 (_tmp37_);
				_tmp38_ = buttons;
				_tmp38__length1 = buttons_length1;
				_tmp39_ = _tmp38_[i];
				gtk_widget_add_css_class ((GtkWidget*) _tmp39_, "circular");
				_tmp40_ = buttons;
				_tmp40__length1 = buttons_length1;
				_tmp41_ = _tmp40_[i];
				gtk_widget_set_halign ((GtkWidget*) _tmp41_, GTK_ALIGN_START);
				_tmp42_ = buttons;
				_tmp42__length1 = buttons_length1;
				_tmp43_ = _tmp42_[i];
				_tmp44_ = gtk_widget_get_first_child ((GtkWidget*) _tmp43_);
				gtk_widget_class_set_accessible_role (G_TYPE_INSTANCE_GET_CLASS (_tmp44_, gtk_widget_get_type (), GtkWidgetClass), GTK_ACCESSIBLE_ROLE_PRESENTATION);
				_tmp45_ = buttons;
				_tmp45__length1 = buttons_length1;
				_tmp46_ = _tmp45_[i];
				gtk_accessible_reset_relation ((GtkAccessible*) _tmp46_, GTK_ACCESSIBLE_RELATION_LABELLED_BY);
				_tmp47_ = buttons;
				_tmp47__length1 = buttons_length1;
				_tmp48_ = _tmp47_[i];
				_tmp49_ = clocks_utils_weekdays_day_name (day);
				_tmp50_ = _tmp49_;
				gtk_accessible_update_property ((GtkAccessible*) _tmp48_, GTK_ACCESSIBLE_PROPERTY_LABEL, _tmp50_, GTK_ACCESSIBLE_PROPERTY_DESCRIPTION, "", -1);
				_g_free0 (_tmp50_);
			}
		}
	}
	first_weekday = clocks_utils_weekdays_day_get_first_weekday ();
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				ClocksUtilsWeekdaysDay day_number = 0;
				GtkBox* _tmp53_;
				GtkToggleButton** _tmp54_;
				gint _tmp54__length1;
				GtkToggleButton* _tmp55_;
				if (!_tmp51_) {
					gint _tmp52_;
					_tmp52_ = i;
					i = _tmp52_ + 1;
				}
				_tmp51_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				day_number = (first_weekday + i) % 7;
				_tmp53_ = self->priv->box;
				_tmp54_ = buttons;
				_tmp54__length1 = buttons_length1;
				_tmp55_ = _tmp54_[day_number];
				gtk_box_append (_tmp53_, (GtkWidget*) _tmp55_);
			}
		}
	}
	clocks_alarm_day_picker_row_update (self);
	buttons = (_vala_array_free (buttons, buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (group);
	return obj;
}

static void
clocks_alarm_day_picker_row_class_init (ClocksAlarmDayPickerRowClass * klass,
                                        gpointer klass_data)
{
	clocks_alarm_day_picker_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ClocksAlarmDayPickerRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_alarm_day_picker_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_alarm_day_picker_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = clocks_alarm_day_picker_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = clocks_alarm_day_picker_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY] = g_param_spec_boolean ("monday", "monday", "monday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY] = g_param_spec_boolean ("tuesday", "tuesday", "tuesday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY] = g_param_spec_boolean ("wednesday", "wednesday", "wednesday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY] = g_param_spec_boolean ("thursday", "thursday", "thursday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY] = g_param_spec_boolean ("friday", "friday", "friday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY] = g_param_spec_boolean ("saturday", "saturday", "saturday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY, clocks_alarm_day_picker_row_properties[CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY] = g_param_spec_boolean ("sunday", "sunday", "sunday", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/alarm-day-picker-row.ui");
	clocks_alarm_day_picker_row_signals[CLOCKS_ALARM_DAY_PICKER_ROW_DAYS_CHANGED_SIGNAL] = g_signal_new ("days-changed", CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "box", FALSE, ClocksAlarmDayPickerRow_private_offset + G_STRUCT_OFFSET (ClocksAlarmDayPickerRowPrivate, box));
}

static void
clocks_alarm_day_picker_row_instance_init (ClocksAlarmDayPickerRow * self,
                                           gpointer klass)
{
	ClocksUtilsWeekdays* _tmp0_;
	self->priv = clocks_alarm_day_picker_row_get_instance_private (self);
	_tmp0_ = clocks_utils_weekdays_new ();
	self->priv->days = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
clocks_alarm_day_picker_row_finalize (GObject * obj)
{
	ClocksAlarmDayPickerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow);
	_clocks_utils_weekdays_unref0 (self->priv->days);
	G_OBJECT_CLASS (clocks_alarm_day_picker_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
clocks_alarm_day_picker_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ClocksAlarmDayPickerRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_alarm_day_picker_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksAlarmDayPickerRow), 0, (GInstanceInitFunc) clocks_alarm_day_picker_row_instance_init, NULL };
	GType clocks_alarm_day_picker_row_type_id;
	clocks_alarm_day_picker_row_type_id = g_type_register_static (adw_preferences_row_get_type (), "ClocksAlarmDayPickerRow", &g_define_type_info, 0);
	ClocksAlarmDayPickerRow_private_offset = g_type_add_instance_private (clocks_alarm_day_picker_row_type_id, sizeof (ClocksAlarmDayPickerRowPrivate));
	return clocks_alarm_day_picker_row_type_id;
}

GType
clocks_alarm_day_picker_row_get_type (void)
{
	static gsize clocks_alarm_day_picker_row_type_id__once = 0;
	if (g_once_init_enter (&clocks_alarm_day_picker_row_type_id__once)) {
		GType clocks_alarm_day_picker_row_type_id;
		clocks_alarm_day_picker_row_type_id = clocks_alarm_day_picker_row_get_type_once ();
		g_once_init_leave (&clocks_alarm_day_picker_row_type_id__once, clocks_alarm_day_picker_row_type_id);
	}
	return clocks_alarm_day_picker_row_type_id__once;
}

static void
_vala_clocks_alarm_day_picker_row_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ClocksAlarmDayPickerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow);
	switch (property_id) {
		case CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_monday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_tuesday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_wednesday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_thursday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_friday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_saturday (self));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY:
		g_value_set_boolean (value, clocks_alarm_day_picker_row_get_sunday (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clocks_alarm_day_picker_row_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ClocksAlarmDayPickerRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_ALARM_TYPE_DAY_PICKER_ROW, ClocksAlarmDayPickerRow);
	switch (property_id) {
		case CLOCKS_ALARM_DAY_PICKER_ROW_MONDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_monday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_TUESDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_tuesday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_WEDNESDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_wednesday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_THURSDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_thursday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_FRIDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_friday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_SATURDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_saturday (self, g_value_get_boolean (value));
		break;
		case CLOCKS_ALARM_DAY_PICKER_ROW_SUNDAY_PROPERTY:
		clocks_alarm_day_picker_row_set_sunday (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

