test_that("jaccard sim works", {
  testthat::skip_if_not_installed("babynames")
  require(babynames)
  require(stringdist)

  for (i in 1:20) {
    nameys <- tolower(unique(babynames$name))
    shuff_nameys <- sample(nameys, length(nameys))


    a <- 1 - stringdist(nameys, shuff_nameys, q = 1, method = "jaccard")
    b <- jaccard_similarity(nameys, shuff_nameys, ngram_width = 1)
    expect_true(all(abs(a - b) < .01))
  }
})

test_that("nthread works", {
  testthat::skip_on_cran()
  testthat::skip_if_not_installed("babynames")


  require(babynames)
  require(stringdist)

  nameys <- tolower(unique(babynames$name))
  shuff_nameys <- sample(nameys, length(nameys))

  runtime <- system.time(jaccard_similarity(
    nameys, shuff_nameys, ngram_width = 1, nthread = 2
  ))
  testthat::expect_lte(runtime['user.self'], 2.5 * runtime['elapsed'])
})
