% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store_memory.R
\docType{class}
\name{zarr_memorystore}
\alias{zarr_memorystore}
\title{In-memory Zarr Store}
\description{
This class implements a Zarr store in RAM memory. With this
class Zarr stores can be read and written to. Obviously, any data is not
persisted after the memory store is de-referenced and garbage-collected.

All data is stored in a list. The Zarr array itself has a list with the
metadata, its chunks have names like "c.0.0.0" and they have an R
array-like value.

This class performs no sanity checks on any of the arguments passed to the
methods, for performance reasons. Since this class should be accessed
through group and array objects, it is up to that code to ensure that
arguments are valid, in particular keys and prefixes.
}
\section{Super class}{
\code{\link[zarr:zarr_store]{zarr::zarr_store}} -> \code{zarr_memorystore}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) Name of the class for printing.}

\item{\code{separator}}{(read-only) The separator of the memory store,
always a dot '.'.}

\item{\code{keys}}{(read-only) The defined keys in the store.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-zarr_memorystore-new}{\code{zarr_memorystore$new()}}
\item \href{#method-zarr_memorystore-exists}{\code{zarr_memorystore$exists()}}
\item \href{#method-zarr_memorystore-clear}{\code{zarr_memorystore$clear()}}
\item \href{#method-zarr_memorystore-erase}{\code{zarr_memorystore$erase()}}
\item \href{#method-zarr_memorystore-erase_prefix}{\code{zarr_memorystore$erase_prefix()}}
\item \href{#method-zarr_memorystore-list_dir}{\code{zarr_memorystore$list_dir()}}
\item \href{#method-zarr_memorystore-list_prefix}{\code{zarr_memorystore$list_prefix()}}
\item \href{#method-zarr_memorystore-set}{\code{zarr_memorystore$set()}}
\item \href{#method-zarr_memorystore-set_if_not_exists}{\code{zarr_memorystore$set_if_not_exists()}}
\item \href{#method-zarr_memorystore-get}{\code{zarr_memorystore$get()}}
\item \href{#method-zarr_memorystore-get_metadata}{\code{zarr_memorystore$get_metadata()}}
\item \href{#method-zarr_memorystore-create_group}{\code{zarr_memorystore$create_group()}}
\item \href{#method-zarr_memorystore-create_array}{\code{zarr_memorystore$create_array()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="getsize"><a href='../../zarr/html/zarr_store.html#method-zarr_store-getsize'><code>zarr::zarr_store$getsize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="getsize_prefix"><a href='../../zarr/html/zarr_store.html#method-zarr_store-getsize_prefix'><code>zarr::zarr_store$getsize_prefix()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="is_empty"><a href='../../zarr/html/zarr_store.html#method-zarr_store-is_empty'><code>zarr::zarr_store$is_empty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="list"><a href='../../zarr/html/zarr_store.html#method-zarr_store-list'><code>zarr::zarr_store$list()</code></a></span></li>
<li><span class="pkg-link" data-pkg="zarr" data-topic="zarr_store" data-id="set_metadata"><a href='../../zarr/html/zarr_store.html#method-zarr_store-set_metadata'><code>zarr::zarr_store$set_metadata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-new"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of this class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-exists"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-exists}{}}}
\subsection{Method \code{exists()}}{
Check if a key exists in the store. The key can point to a
group, an array (having a metadata list as its value) or a chunk.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Character string. The key that the store will be searched for.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if argument \code{key} is found, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-clear"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-clear}{}}}
\subsection{Method \code{clear()}}{
Clear the store. Remove all keys and values from the store.
Invoking this method deletes all data and this action can not be
undone.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE}. This operation always proceeds successfully once invoked.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-erase"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-erase}{}}}
\subsection{Method \code{erase()}}{
Remove a key from the store. The key must point to an array
or a chunk. If the key points to an array, the key and all of
subordinated keys are removed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$erase(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Character string. The key to remove from the store.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE}. This operation always proceeds successfully once invoked,
even if argument \code{key} does not point to an existing key.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-erase_prefix"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-erase_prefix}{}}}
\subsection{Method \code{erase_prefix()}}{
Remove all keys in the store that begin with a given prefix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$erase_prefix(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Character string. The prefix to groups or arrays to remove
from the store, including in child groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE}. This operation always proceeds successfully once invoked,
even if argument \code{prefix} does not point to any existing keys.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-list_dir"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-list_dir}{}}}
\subsection{Method \code{list_dir()}}{
Retrieve all keys with a given prefix and which do not
contain the character "/" after the given prefix. In other words, this
retrieves all the keys in the store below the key indicated by the
prefix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$list_dir(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Character string. The prefix whose nodes to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character array with all keys found in the store immediately
below the \code{prefix}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-list_prefix"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-list_prefix}{}}}
\subsection{Method \code{list_prefix()}}{
Retrieve all keys and prefixes with a given prefix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$list_prefix(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{Character string. The prefix to nodes to list.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character vector with all paths found in the store below the
\code{prefix} location.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-set"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-set}{}}}
\subsection{Method \code{set()}}{
Store a \verb{(key, value)} pair. If the \code{value} exists, it will
be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$set(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The key whose value to set.}

\item{\code{value}}{The value to set, typically a complete chunk of data, a
\code{raw} vector.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-set_if_not_exists"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-set_if_not_exists}{}}}
\subsection{Method \code{set_if_not_exists()}}{
Store a \verb{(key, value)} pair. If the \code{key} exists, nothing
will be written.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$set_if_not_exists(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{The key whose value to set.}

\item{\code{value}}{The value to set, a complete chunk of data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly, or an error.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-get"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-get}{}}}
\subsection{Method \code{get()}}{
Retrieve the value associated with a given key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$get(key, prototype = NULL, byte_range = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Character string. The key for which to get data.}

\item{\code{prototype}}{Ignored. The only buffer type that is supported maps
directly to an R raw vector.}

\item{\code{byte_range}}{If \code{NULL}, all data associated with the key is
retrieved. If a single positive integer, all bytes starting from a
given byte offset to the end of the object are returned. If a single
negative integer, the final bytes are returned. If an integer vector of
length 2, request a specific range of bytes where the end is exclusive.
If the range ends after the end of the object, the entire remainder of
the object will be returned. If the given range is zero-length or
starts after the end of the object, an error will be returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An raw vector of data, or \code{NULL} if no data was found.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Retrieve the metadata document at the location indicated by
the \code{prefix} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$get_metadata(prefix)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prefix}}{The prefix whose metadata document to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the metadata, or \code{NULL} if the prefix is not pointing
to a Zarr array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-create_group"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-create_group}{}}}
\subsection{Method \code{create_group()}}{
Create a new group in the store under the specified path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$create_group(path, name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{The path to the parent group of the new group. Ignored when
creating a root group.}

\item{\code{name}}{The name of the new group. This may be an empty string \code{""}
to create a root group. It is an error to supply an empty string if a
root group or array already exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the metadata of the group, or an error if the group
could not be created.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-zarr_memorystore-create_array"></a>}}
\if{latex}{\out{\hypertarget{method-zarr_memorystore-create_array}{}}}
\subsection{Method \code{create_array()}}{
Create a new array in the store under key constructed from
the specified path to the \code{parent} argument and the \code{name}. The key may
not already exist in the store.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{zarr_memorystore$create_array(parent, name, metadata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{The path to the parent group of the new array. This is
ignored if the \code{name} argument is the empty string.}

\item{\code{name}}{The name of the new array.}

\item{\code{metadata}}{A \code{list} with the metadata for the array. The list has to
be valid for array construction. Use the \link{array_builder} class to
create and or test for validity. An element "chunk_key_encoding" will
be added to the metadata if it not already there or contains an invalid
separator.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the metadata of the array, or an error if the array
could not be created.
}
}
}
