% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regexpr.R
\name{set_PCRE}
\alias{set_PCRE}
\alias{set_TRE}
\alias{use_perl}
\alias{set_regexpr_style}
\alias{auto_set_regexpr_style}
\title{Switch regular expression style (PCRE vs TRE)}
\usage{
set_PCRE()

set_TRE()

use_perl()

set_regexpr_style(style)

auto_set_regexpr_style()
}
\arguments{
\item{style}{one of 'PCRE' or 'TRE'}
}
\value{
Logical indicating whether to use \code{perl}
}
\description{
\itemize{
\item \code{set_regexpr_style()} selects the style explicitly.
\item \code{auto_set_regexpr_style()} chooses based on OS (TRE on Windows; PCRE elsewhere).
\item \code{set_PCRE()} and \code{set_TRE()} force the style.
}
}
\details{
These functions do not change the behavior of \code{gsub()}/\code{regexpr()} directly.
They set a global option that you can read via \code{use_perl()} and pass to \code{gsub()}/\code{regexpr()}.
}
\references{
https://stackoverflow.com/questions/47240375/regular-expressions-in-base-r-perl-true-vs-the-default-pcre-vs-tre
}
\author{
Guangchuang Yu
}
\concept{regex-utils}
