% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MarginalPermutationSampler.R
\name{MarginalPermutationSampler}
\alias{MarginalPermutationSampler}
\title{Marginal Permutation Sampler}
\description{
Implements marginal permutation-based sampling for Permutation Feature Importance (PFI).
Each specified feature is randomly shuffled (permuted) independently, breaking the
relationship between the feature and the target as well as between rows.
}
\details{
The permutation sampler randomly shuffles feature values across observations:
\itemize{
\item Each feature is permuted \strong{independently} within its column
\item The association between feature values and target values is broken
\item The association between feature values \strong{across rows} is broken
\item The marginal distribution of each feature is preserved
}

\strong{Important distinction from SAGE's "marginal" approach:}
\itemize{
\item \code{MarginalPermutationSampler}: Shuffles features independently, breaking row structure
\item \code{MarginalSAGE}: Uses reference data but keeps rows intact (features in coalition stay together)
}

This is the classic approach used in Permutation Feature Importance (PFI) and
assumes features are independent.
}
\examples{
library(mlr3)
task = tgen("2dnormals")$generate(n = 10)
task$data()
sampler = MarginalPermutationSampler$new(task)

# Sample using row_ids from stored task
sampler$sample("x1")

# Or use external data
data = task$data()
sampler$sample_newdata("x1", newdata = data)
}
\section{Super classes}{
\code{\link[xplainfi:FeatureSampler]{xplainfi::FeatureSampler}} -> \code{\link[xplainfi:MarginalSampler]{xplainfi::MarginalSampler}} -> \code{MarginalPermutationSampler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MarginalPermutationSampler-new}{\code{MarginalPermutationSampler$new()}}
\item \href{#method-MarginalPermutationSampler-clone}{\code{MarginalPermutationSampler$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="FeatureSampler" data-id="print"><a href='../../xplainfi/html/FeatureSampler.html#method-FeatureSampler-print'><code>xplainfi::FeatureSampler$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="MarginalSampler" data-id="sample"><a href='../../xplainfi/html/MarginalSampler.html#method-MarginalSampler-sample'><code>xplainfi::MarginalSampler$sample()</code></a></span></li>
<li><span class="pkg-link" data-pkg="xplainfi" data-topic="MarginalSampler" data-id="sample_newdata"><a href='../../xplainfi/html/MarginalSampler.html#method-MarginalSampler-sample_newdata'><code>xplainfi::MarginalSampler$sample_newdata()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalPermutationSampler-new"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalPermutationSampler-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of the MarginalPermutationSampler class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalPermutationSampler$new(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{(\link[mlr3:Task]{mlr3::Task}) Task to sample from.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MarginalPermutationSampler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MarginalPermutationSampler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MarginalPermutationSampler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
