# Extracted from test-MarginalSAGE.R:256

# test -------------------------------------------------------------------------
skip_if_not_installed("ranger")
skip_if_not_installed("mlr3learners")
set.seed(123)
task = tgen("friedman1")$generate(n = 100)
learner = lrn("regr.ranger", num.trees = 50)
measure = msr("regr.mse")
sage = MarginalSAGE$new(
		task = task,
		learner = learner,
		measure = measure,
		n_permutations = 10L,
		n_samples = 20L
	)
sage$compute(
		early_stopping = TRUE,
		se_threshold = 100.0,
		min_permutations = 5L,
		check_interval = 1L
	)
