# Extracted from test-CFI.R:329

# setup ------------------------------------------------------------------------
library(testthat)
test_env <- simulate_test_env(package = "xplainfi", path = "..")
attach(test_env, warn.conflicts = FALSE)

# test -------------------------------------------------------------------------
skip_if_not_installed("knockoff")
set.seed(123)
task = sim_dgp_correlated(n = 50)
learner = lrn("regr.rpart")
measure = msr("regr.mse")
resampling = rsmp("subsampling", repeats = 5)
gaussian_sampler = KnockoffGaussianSampler$new(task)
cfi = CFI$new(
		task = task,
		learner = learner,
		measure = measure,
		resampling = resampling,
		sampler = gaussian_sampler
	)
cfi$compute()
