% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sage-internals.R
\name{sage_aggregate_predictions}
\alias{sage_aggregate_predictions}
\title{Aggregate Predictions by Coalition and Test Instance}
\usage{
sage_aggregate_predictions(
  combined_data,
  predictions,
  task_type,
  class_names = NULL
)
}
\arguments{
\item{combined_data}{(\code{data.table}) Data with columns \code{.coalition_id}, \code{.test_instance_id},
and feature columns.}

\item{predictions}{(\code{matrix} or \code{numeric}) For classification: matrix of class probabilities.
For regression: numeric vector of predictions.}

\item{task_type}{(\code{character(1)}) Task type, either \code{"classif"} or \code{"regr"}.}

\item{class_names}{(\code{character()} or \code{NULL}: \code{NULL}) Character vector of class names. Required
for classification, ignored for regression.}
}
\value{
\code{data.table} with columns:
\itemize{
\item \code{.coalition_id}: Coalition identifier (integer)
\item \code{.test_instance_id}: Test instance identifier (integer)
\item For classification: One column per class with averaged probabilities (numeric)
\item For regression: \code{avg_pred} column with averaged predictions (numeric)
}
}
\description{
Averages predictions across multiple samples (reference data or conditional samples)
for each unique combination of coalition and test instance.
}
\keyword{internal}
