% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_question_block_table.R
\name{build_qtable}
\alias{build_qtable}
\title{Summarize a Question Block}
\usage{
build_qtable(
  x,
  block_cols,
  cols = NULL,
  table_title = "",
  use_questions = FALSE,
  use_NA = FALSE,
  wt = NULL,
  footnote = ""
)
}
\arguments{
\item{x}{A data frame or tibble containing survey data.}

\item{block_cols}{<\link[tidyr]{tidyr_tidy_select}> Columns that form the
question block. All selected columns must have identical response options.
Tip: Use \code{starts_with('prefix')} when block columns share a common prefix.
See Examples.}

\item{cols}{<\link[tidyr]{tidyr_tidy_select}> Optional column(s) to
cross-tabulate against the question block (for example, demographics).}

\item{table_title}{Character string. Title for the output table.}

\item{use_questions}{Logical. If \code{TRUE} and data contains column labels
(from .sav files), adds the full question text as a footnote. Default is
\code{FALSE}.}

\item{use_NA}{Logical. Whether to include \code{NA} values in the table. Default
is \code{TRUE}. For advanced \code{NA} handling, use \code{filter()} before table creation.}

\item{wt}{Column name (quoted or unquoted) for weighting variable. If \code{NULL}
(default), no weighting is applied.}

\item{footnote}{Character vector. Custom footnote text. When provided,
overrides \code{use_questions}.}
}
\value{
An \code{xlr_table} object. Write to Excel using \code{\link[=write_xlsx]{write_xlsx()}}.
See \link{xlr_table} for details.
}
\description{
Analyzes a block of related questions (such as matrix questions) and presents
them in a single summary table. Optionally cross-tabulates results by other
variables. All questions in the block must share the same response options.
}
\details{
This function works best with \code{haven::labelled} data, which is created when
importing SPSS files (.sav) using \code{haven::read_sav()}. This format preserves
question text and response option labels from survey platforms like Qualtrics.

\strong{Important:} All questions in the block must have identical response options.
The function uses the first question to determine valid response values. If
you encounter errors, convert the block columns to factors beforehand to ensure
consistency.

By default this function converts \link[haven]{labelled} to a \link{xlr_vector}
by default (and underlying it is a \code{character()} type).

See \link[haven]{labelled} and \link[haven]{read_sav} if you would like more
details on the importing type.
}
\examples{
library(xlr)

# You can use this function to get a block of questions
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  table_title = "This is an example table")

# Another way you could select the same columns
build_qtable(
  clothes_opinions,
  c(Q1_1,Q1_2,Q1_3,Q1_4),
  table_title = "This is an example table")

# Yet another way to select the same columns
build_qtable(
  clothes_opinions,
  all_of(c("Q1_1","Q1_2","Q1_3","Q1_4")),
  table_title = "This is an example table")
# You can also cut all questions in the block by a single column
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  gender2,
  table_title = "This is the second example table")

# You can also cut all questions in the block by a multiple columns
# By setting `use_questions=TRUE` then the footnote will be the questions
# labels, for the cut questions
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  c(gender2,age_group),
  table_title = "This is the third example table",
  use_questions = TRUE)

# You can also use weights, these weights can be either doubles or integers
# based weights
# You can also set a footnote
build_qtable(
  clothes_opinions,
  starts_with("Q1"),
  age_group,
  table_title = "This is the fourth example table",
  wt = weight,
  footnote = paste0("This is a footnote, you can use it if you want ",
                    "more detail in your table."))
}
\seealso{
\code{\link[=build_table]{build_table()}}, \code{\link[=build_qtable]{build_qtable()}}
}
