% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooling.R
\name{CoolingFactory}
\alias{CoolingFactory}
\title{Configure the cooling schedule of the acceptance 
function of a genetic algorithm.}
\usage{
CoolingFactory(method = "ExponentialMultiplicative")
}
\arguments{
\item{method}{A string specifying the cooling schedule.}
}
\value{
A cooling schedule.
}
\description{
\code{CoolingFactory()} implements selection
             of a cooling schedule method.

Current support:

\enumerate{
  \item "ExponentialMultiplicative" returns 
       \code{ExponentialMultiplicativeCooling}. (Default)
  \item "LogarithmicMultiplicative" returns 
       \code{LogarithmicMultiplicativeCooling}.
  \item "PowerMultiplicative" returns 
       \code{PowerMultiplicativeCooling}.
       \code{coolingPower=1} specifies linear multiplicative cooling,  
       \code{coolingPower=2} specifies quadratic multiplicative cooling.
  \item "PowerAdditive" returns 
       \code{PowerAdditiveCooling}.
       \code{coolingPower=1} specifies linear additive cooling,  
       \code{coolingPower=2} specifies quadratic additive cooling.
  \item "ExponentialAdditive" returns 
       \code{ExponentialAdditiveCooling}.
  \item "TrigonometricAdditive" returns 
       \code{TrigonometricAdditiveCooling}.
   }
}
\seealso{
Other Configuration: 
\code{\link{AcceptFactory}()},
\code{\link{ApplyFactory}()},
\code{\link{CrossRateFactory}()},
\code{\link{MutationRateFactory}()},
\code{\link{TerminationFactory}()},
\code{\link{checkTerminationFactory}()},
\code{\link{xegaAsPipelineFactory}()},
\code{\link{xegaConfiguration}()},
\code{\link{xegaEvalPopulationFactory}()}
}
\concept{Configuration}
