% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCross2Mut2PipelineG}
\alias{newCross2Mut2PipelineG}
\title{Converts two genes into a pipeline embedded in a gene with crossover (2 kids) and mutation for second kid.}
\usage{
newCross2Mut2PipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with crossover with 2 kids and mutation on the second kid only.
        The argument \code{lF} of the function \code{Pipeline}
        configures the behavior of the pipeline.
}
\description{
The embdded pipeline is \code{evaluate(accept((crossover o mutation), gene, gene1))}.
             Mutation is applied to the second kid.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$BitMutationRate1<-function(fit, lF) {1.0}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OpPipeline, gene, lF) {OpPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCross2Mut1PipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
