% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataEnvironment.R
\name{DataEnvironment}
\alias{DataEnvironment}
\title{DataEnvironment R6 Class}
\description{
Manages dataframe storage in package environment (.pkg_env$.wizaRdry_env) with optional
convenience assignment to calling environment. CRAN-compliant environment management.
}
\details{
This class provides a clean interface for getting and setting dataframes using the package
environment (.pkg_env) as the authoritative source, with optional assignment to the calling
environment for user convenience. This eliminates global environment pollution and follows
R package best practices.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{measure_name}}{Character string - name of the measure/dataframe}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataEnvironment-new}{\code{DataEnvironment$new()}}
\item \href{#method-DataEnvironment-get_df}{\code{DataEnvironment$get_df()}}
\item \href{#method-DataEnvironment-set_df}{\code{DataEnvironment$set_df()}}
\item \href{#method-DataEnvironment-get_colnames}{\code{DataEnvironment$get_colnames()}}
\item \href{#method-DataEnvironment-nrow}{\code{DataEnvironment$nrow()}}
\item \href{#method-DataEnvironment-ncol}{\code{DataEnvironment$ncol()}}
\item \href{#method-DataEnvironment-print}{\code{DataEnvironment$print()}}
\item \href{#method-DataEnvironment-clone}{\code{DataEnvironment$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-new}{}}}
\subsection{Method \code{new()}}{
Create a new DataEnvironment instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$new(measure_name, df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure_name}}{Name of the measure/dataframe}

\item{\code{df}}{Initial dataframe to store}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new DataEnvironment object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-get_df"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-get_df}{}}}
\subsection{Method \code{get_df()}}{
Get dataframe from package environment or calling environment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$get_df()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The dataframe stored in package environment
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-set_df"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-set_df}{}}}
\subsection{Method \code{set_df()}}{
Set dataframe in package environment with optional calling environment assignment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$set_df(df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df}}{Data frame to set}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self (invisibly) for method chaining
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-get_colnames"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-get_colnames}{}}}
\subsection{Method \code{get_colnames()}}{
Get column names from the dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$get_colnames()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector of column names
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-nrow"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-nrow}{}}}
\subsection{Method \code{nrow()}}{
Get number of rows in the dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$nrow()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of rows
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-ncol"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-ncol}{}}}
\subsection{Method \code{ncol()}}{
Get number of columns in the dataframe
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$ncol()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer number of columns
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-print"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-print}{}}}
\subsection{Method \code{print()}}{
Print method for DataEnvironment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self (invisibly)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataEnvironment-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataEnvironment-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataEnvironment$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
