% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_loq.R
\name{define_loq}
\alias{define_loq}
\title{Check and standardize limits of quantification}
\usage{
define_loq(
  lloq = NULL,
  uloq = NULL,
  pred_corr = FALSE,
  pred_corr_lower_bnd = 0,
  require_loq
)
}
\arguments{
\item{lloq}{Number or NULL indicating lower limit of quantification. Default is NULL.}

\item{uloq}{Number or NULL indicating upper limit of quantification. Default is NULL.}

\item{pred_corr}{perform prediction-correction?}

\item{pred_corr_lower_bnd}{lower bound for the prediction-correction}

\item{require_loq}{Is at least one of \code{lloq} or \code{uloq} required?}
}
\value{
A list with elements "lloq", "uloq", "cens_limit", "pred_corr",
  "pred_corr_lower_bnd", and "cens_type".  "cens_limit" indicates the range
  for censoring (\code{c(lloq, uloq)}, \code{NULL} if neither is given),
  "cens_type" indicates whether the data are "left" censored (low values are
  censored, only), "right" (high values are censored, only), "both" (low and
  high values are censored), or "neither" (no values are censored).
}
\description{
Check and standardize limits of quantification
}
