% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vismi_converge.R
\name{vismi_converge}
\alias{vismi_converge}
\title{Visualise convergence diagnostics}
\usage{
vismi_converge(
  obj,
  x,
  xlim = NULL,
  mean_lim = NULL,
  sd_lim = NULL,
  title = "auto",
  subtitle = "auto",
  tick_vals = NULL,
  color_pal = NULL,
  linewidth = 0.8,
  ...
)
}
\arguments{
\item{obj}{A 'mixgb' object returned by \code{mixgb()} function or a 'mids' object returned by the \code{mice()} function.}

\item{x}{The name of the variable to plot convergence for.}

\item{xlim}{Optional numeric vector of length 2 specifying the x-axis limits for iterations.}

\item{mean_lim}{Optional numeric vector of length 2 specifying the y-axis limits for mean values of the variable.}

\item{sd_lim}{Optional numeric vector of length 2 specifying the y-axis limits for standard deviation values of the variable.}

\item{title}{A string specifying the title of the plot. If NULL, no title is shown. If "auto", a title will be generated based on the input. Default is "auto".}

\item{subtitle}{A string specifying the subtitle of the plot. If NULL, no subtitle is shown. If "auto", a title will be generated based on the input. Default is "auto".}

\item{tick_vals}{Optional numeric vector specifying x-axis tick values for iterations.}

\item{color_pal}{A vector of m color codes (e.g., hex codes). If NULL, default colors will be used.}

\item{linewidth}{The line width for the plot lines. Default is 0.8.}

\item{...}{Additional arguments.}
}
\value{
Two side-by-side ggplot2 object showing the mean and standard deviation (SD) of imputed values for a specified variable across iterations.
}
\description{
This function generates convergence diagnostic plots showing the mean and standard deviation (SD) of imputed values for a specified variable across iterations.
}
\examples{
library(mixgb)
set.seed(2026)
mixgb_obj <- mixgb(data = nhanes3, m = 3, maxit = 4, pmm.type = "auto", save.models = TRUE)
vismi_converge(obj = mixgb_obj, x = "recumbent_length_cm")
}
