% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_p.R
\name{nice_p}
\alias{nice_p}
\title{Nice printing of p-values}
\usage{
nice_p(p_val, print_zero = FALSE)
}
\arguments{
\item{p_val}{A numeric. The p-value to format.}

\item{print_zero}{A logical. Should leading zero be printed? (see Details)}
}
\value{
A character vector with the formatted p-value(s)
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Formatting function
for consistent p-value reporting.

You can choose to print the leading zero (e.g. \code{0.01}) or not
(e.g. \code{.01}) with \code{print_zero}.
}
\examples{
pvals <-
  c(0.056548, 0.0002654, 0.816546, 0.0493321)
nice_p(pvals)

nice_p(pvals, print_zero = TRUE)
}
\keyword{pvalue}
