% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ind.R
\name{add_ind}
\alias{add_ind}
\title{Add indication column(s) to a dataset}
\usage{
add_ind(.data, i_list, i_names = names(i_list), drug_data, ind_data)
}
\arguments{
\item{.data}{The dataset used to identify individual reports (usually, it is \code{demo})}

\item{i_list}{A named list of indication terms. See Details.}

\item{i_names}{A character vector. Names for indication columns (must be the same length as i_list), default to \code{names(i_list)}}

\item{drug_data}{A data.frame containing the drug data (usually, it is \code{drug})}

\item{ind_data}{A data.frame containing the indication data (usually, it is \code{ind})}
}
\value{
A dataset with the new indication columns.
Each element of \code{i_names} will add a column with the same name in \code{.data}.
The value can be
\itemize{
\item 0 The corresponding indication is absent.
\item 1 The indication is present in the case if \code{.data} is \code{demo} or \code{adr},
or "this row correspond to this indication",
if \code{.data} is \code{drug}, \code{link} or \code{ind}).
\item NA There is no indication data for this case / drug.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Creates indication columns.
in vigibase datasets (demo, link, adr, drug, or ind).
}
\details{
Indication terms are issued from either MedDRA or International
Classification of Diseases (ICD) - you need to use \emph{both} dictionaries, should
you wish to capture all terms related to a specific disease.
Indication terms are not translated into codes in VigiBase ECL,
unlike drug or adr terms. Therefore, there is no \verb{get_*} step to collect
such codes. The terms are passed directly to \code{i_list}, which should still be
a \emph{named} list containing indication terms.
}
\examples{

# Set up a list of indication terms

i_list <-
  list(
    melanoma = c("Malignant melanoma", "Metastatic malignant melanoma"),
    lung_cancer = c("Non-small cell lung cancer", "Lung adenocarcinoma")
    )

 demo <-
   demo_ |>
   add_ind(i_list,
           drug_data = drug_,
           ind_data  = ind_)

 demo |> desc_facvar(names(i_list))
}
\seealso{
\code{\link[=add_adr]{add_adr()}}, \code{\link[=add_drug]{add_drug()}}
}
