% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{vetiver_api}
\alias{vetiver_api}
\alias{vetiver_pr_post}
\alias{vetiver_pr_docs}
\title{Create a Plumber API to predict with a deployable \code{vetiver_model()} object}
\usage{
vetiver_api(
  pr,
  vetiver_model,
  path = "/predict",
  debug = is_interactive(),
  ...
)

vetiver_pr_post(
  pr,
  vetiver_model,
  path = "/predict",
  debug = is_interactive(),
  ...,
  check_prototype = TRUE,
  check_ptype = deprecated()
)

vetiver_pr_docs(pr, vetiver_model, path = "/predict", all_docs = TRUE)
}
\arguments{
\item{pr}{A Plumber router, such as from \code{\link[plumber:pr]{plumber::pr()}}.}

\item{vetiver_model}{A deployable \code{\link[=vetiver_model]{vetiver_model()}} object}

\item{path}{The endpoint path}

\item{debug}{\code{TRUE} provides more insight into your API errors.}

\item{...}{Other arguments passed to \code{predict()}, such as prediction \code{type}}

\item{check_prototype}{Should the input data prototype stored in
\code{vetiver_model} (used for visual API documentation) also be used to check
new data at prediction time? Defaults to \code{TRUE}.}

\item{check_ptype}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{all_docs}{Should the interactive visual API documentation be created
for \emph{all} POST endpoints in the router \code{pr}? This defaults to \code{TRUE}, and
assumes that all POST endpoints use the \code{\link[=vetiver_model]{vetiver_model()}} input data
prototype.}
}
\value{
A Plumber router with the prediction endpoint added.
}
\description{
Use \code{vetiver_api()} to add a POST endpoint for predictions from a
trained \code{\link[=vetiver_model]{vetiver_model()}} to a Plumber router.
}
\details{
You can first store and version your \code{\link[=vetiver_model]{vetiver_model()}} with
\code{\link[=vetiver_pin_write]{vetiver_pin_write()}}, and then create an API endpoint with \code{vetiver_api()}.

Setting \code{debug = TRUE} may expose any sensitive data from your model in
API errors.

Several GET endpoints will also be added to the router \code{pr}, depending on the
characteristics of the model object:
\itemize{
\item a \verb{/pin-url} endpoint to return the URL of the pinned model
\item a \verb{/metadata} endpoint to return any metadata stored with the model
\item a \verb{/ping} endpoint for the API health
\item a \verb{/prototype} endpoint for the model's input data prototype (use
\code{\link[cereal:cereal_to_json]{cereal::cereal_from_json()}}) to convert this back to a \href{https://vctrs.r-lib.org/articles/type-size.html}{vctrs ptype}
}

The function \code{vetiver_api()} uses:
\itemize{
\item \code{vetiver_pr_post()} for endpoint definition and
\item \code{vetiver_pr_docs()} to create visual API documentation
}

These modular functions are available for more advanced use cases.
}
\examples{
\dontshow{if (rlang::is_installed("plumber")) withAutoprint(\{ # examplesIf}

cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")

library(plumber)
pr() |> vetiver_api(v)
## is the same as:
pr() |> vetiver_pr_post(v) |> vetiver_pr_docs(v)
## for either, next, pipe to `pr_run()`
\dontshow{\}) # examplesIf}
}
